/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.demo.job;

import com.rocoinfo.oilcard.batch.base.listener.BatchJobListener;
import com.rocoinfo.oilcard.batch.demo.job.NestingJobCore;
import com.rocoinfo.oilcard.batch.demo.step.BatchStepCore;
import com.rocoinfo.oilcard.batch.handler.batch.StepExecutionStatusHandler;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.job.builder.FlowJobBuilder;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class BatchJobCore {
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Autowired
    private StepExecutionStatusHandler stepExecutionStatusService;

    @Bean
    public Job initStepJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("initStepJob").start(BatchStepCore.initStep((StepBuilderFactory)this.stepBuilderFactory)).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    @Bean
    public Job parallelStepJob1() throws Exception {
        return ((FlowJobBuilder)((FlowJobBuilder)((JobBuilder)this.jobBuilderFactory.get("parallelStepJob1").incrementer((JobParametersIncrementer)new RunIdIncrementer())).start(NestingJobCore.parallelJobStep1((JobBuilderFactory)this.jobBuilderFactory, (StepBuilderFactory)this.stepBuilderFactory, (JobRepository)this.jobRepository, (StepExecutionStatusHandler)this.stepExecutionStatusService)).split((TaskExecutor)new SimpleAsyncTaskExecutor()).add(new Flow[]{NestingJobCore.flowParallel1((JobBuilderFactory)this.jobBuilderFactory, (StepBuilderFactory)this.stepBuilderFactory, (JobRepository)this.jobRepository, (StepExecutionStatusHandler)this.stepExecutionStatusService)}).end()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    @Bean
    public Job fourStepJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("fourStepJob").start(BatchStepCore.fourStep((StepBuilderFactory)this.stepBuilderFactory)).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    @Bean
    public Job parallelStepJob2() throws Exception {
        return ((FlowJobBuilder)((FlowJobBuilder)((JobBuilder)this.jobBuilderFactory.get("parallelStepJob2").incrementer((JobParametersIncrementer)new RunIdIncrementer())).start(NestingJobCore.parallelJobStep2((JobBuilderFactory)this.jobBuilderFactory, (StepBuilderFactory)this.stepBuilderFactory, (JobRepository)this.jobRepository, (StepExecutionStatusHandler)this.stepExecutionStatusService)).split((TaskExecutor)new SimpleAsyncTaskExecutor()).add(new Flow[]{NestingJobCore.flowParallel2((JobBuilderFactory)this.jobBuilderFactory, (StepBuilderFactory)this.stepBuilderFactory, (JobRepository)this.jobRepository, (StepExecutionStatusHandler)this.stepExecutionStatusService)}).end()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    @Bean
    public Job sevenStepJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("sevenStepJob").start(BatchStepCore.sevenStep((StepBuilderFactory)this.stepBuilderFactory)).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }
}

