/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.handler.invoice;

import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.template.BaseSingleTemplate;
import com.rocoinfo.oilcard.batch.api.entity.job.StepExecutionStatus;
import com.rocoinfo.oilcard.batch.api.request.common.JobNodesReq;
import com.rocoinfo.oilcard.batch.base.common.CommonJobParam;
import com.rocoinfo.oilcard.batch.base.job.StartBatchJob;
import com.rocoinfo.oilcard.batch.dao.batch.StepExecutionStatusDao;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEventDao;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class InvoiceEnterpriseStatisticMiddleSingleStartHandler
extends BaseSingleTemplate<JobNodesReq, Boolean> {
    @Autowired
    @Qualifier(value="resetInvoiceEnterMiddleJob")
    private Job resetInvoiceEnterMiddleJob;
    @Autowired
    @Qualifier(value="invoiceEnterTranstionMiddleJob")
    private Job invoiceEnterTranstionMiddleJob;
    @Autowired
    @Qualifier(value="invoiceEnterDayMiddleJob")
    private Job invoiceEnterDayMiddleJob;
    @Autowired
    @Qualifier(value="invoiceEnterWeekMiddleJob")
    private Job invoiceEnterWeekMiddleJob;
    @Autowired
    @Qualifier(value="invoiceEnterMonthMiddleJob")
    private Job invoiceEnterMonthMiddleJob;
    @Autowired
    @Qualifier(value="invoiceEnterAccumulateMiddleJob")
    private Job invoiceEnterAccumulateMiddleJob;
    @Autowired
    private CommonJobParam commonJobParam;
    @Autowired
    private StepExecutionStatusDao stepExecutionStatusDao;
    @Autowired
    @Qualifier(value="batchTaskExecutor")
    private ThreadPoolTaskExecutor batchTaskExecutor;
    @Autowired
    private InvoiceEventDao invoiceEventDao;

    protected Boolean callInner(CommonRequest<JobNodesReq> request) throws Exception {
        this.startSingleJob((JobNodesReq)request.getRequest());
        return true;
    }

    public void startSingleJob(JobNodesReq jobNodesReq) throws Exception {
        String endTime;
        LocalDate currentDay = LocalDate.now();
        String startTime = currentDay.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 00:00:00";
        Map map = this.invoiceEventDao.getStartEndDate(startTime, endTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        if (map != null && map.size() > 0) {
            String startDateStr = map.get("start_date").toString();
            String endDateStr = map.get("end_date").toString();
            JobParameters jobParameters = new JobParametersBuilder().addString("startDate", startDateStr).addString("endDate", endDateStr).addString("startTime", startTime).addString("endTime", endTime).addLong("timeStamp", Long.valueOf(System.currentTimeMillis())).toJobParameters();
            StepExecutionStatus stepExecutionStatus = this.stepExecutionStatusDao.getByPkId(jobNodesReq.getId());
            this.batchTaskExecutor.execute((Runnable)new StartBatchJob(this.commonJobParam.getJobLauncher(), this.getNextJob(stepExecutionStatus.getStepName()), jobParameters));
        }
    }

    private Map<Integer, Job> getNextJob(String currentJob) throws Exception {
        switch (currentJob) {
            case "resetInvoiceEnterMiddleJob": {
                return this.commonJobParam.jobNameList(new Job[]{this.resetInvoiceEnterMiddleJob, this.invoiceEnterTranstionMiddleJob, this.invoiceEnterDayMiddleJob, this.invoiceEnterWeekMiddleJob, this.invoiceEnterMonthMiddleJob, this.invoiceEnterAccumulateMiddleJob});
            }
            case "invoiceEnterTranstionMiddleJob": {
                return this.commonJobParam.jobNameList(new Job[]{this.invoiceEnterTranstionMiddleJob, this.invoiceEnterDayMiddleJob, this.invoiceEnterWeekMiddleJob, this.invoiceEnterMonthMiddleJob, this.invoiceEnterAccumulateMiddleJob});
            }
            case "invoiceEnterDayMiddleJob": {
                return this.commonJobParam.jobNameList(new Job[]{this.invoiceEnterDayMiddleJob, this.invoiceEnterWeekMiddleJob, this.invoiceEnterMonthMiddleJob, this.invoiceEnterAccumulateMiddleJob});
            }
            case "invoiceEnterWeekMiddleJob": {
                return this.commonJobParam.jobNameList(new Job[]{this.invoiceEnterWeekMiddleJob, this.invoiceEnterMonthMiddleJob, this.invoiceEnterAccumulateMiddleJob});
            }
            case "invoiceEnterMonthMiddleJob": {
                return this.commonJobParam.jobNameList(new Job[]{this.invoiceEnterMonthMiddleJob, this.invoiceEnterAccumulateMiddleJob});
            }
        }
        return null;
    }
}

