/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.base.listener;

import com.rocoinfo.oilcard.batch.handler.batch.StepExecutionStatusHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;

public class BatchJobListener
extends JobExecutionListenerSupport {
    private Logger logger = LoggerFactory.getLogger(BatchJobListener.class);
    private StepExecutionStatusHandler stepExecutionStatusService;

    public BatchJobListener(StepExecutionStatusHandler stepExecutionStatusService) {
        this.stepExecutionStatusService = stepExecutionStatusService;
    }

    public void beforeJob(JobExecution jobExecution) {
        if (jobExecution.getJobInstance().getJobName().indexOf("init") != -1) {
            this.stepExecutionStatusService.updateStepStatusToInit(jobExecution.getJobInstance().getJobName());
        }
        this.stepExecutionStatusService.updateStepStatus(jobExecution.getJobInstance().getJobName(), jobExecution.getId(), "STARTED");
        this.logger.info("\u3010{}\u3011job\u5df2\u542f\u52a8,JobId\u3010{}\u3011", (Object)jobExecution.getJobInstance().getJobName(), (Object)jobExecution.getId());
    }

    public void afterJob(JobExecution jobExecution) {
        String statusType = "FAILED".equals(jobExecution.getExitStatus().getExitCode()) ? "FAILED" : "COMPLETED";
        this.stepExecutionStatusService.updateStepStatus(jobExecution.getJobInstance().getJobName(), null, statusType);
        this.logger.info("\u3010{}\u3011Job\u6267\u884c\u5b8c\u6210\uff0c\u5b8c\u6210\u6807\u8bb0\uff1a\u3010{}\u3011", (Object)jobExecution.getJobInstance().getJobName(), (Object)jobExecution.getExitStatus().getExitCode());
    }
}

