/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.demo.commonobj;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StatusDto<T> {
    public static final String SUCCESS_MSG = "Success!";
    public static final String FAILURE_MSG = "failure!";
    public static final String SUCCESS_CODE = "1";
    public static final String FAILURE_CODE = "0";
    protected String code;
    protected String message;
    protected T data;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isSuccess() {
        return SUCCESS_CODE.equals(this.code);
    }

    public boolean isFail() {
        return FAILURE_CODE.equals(this.code);
    }

    public StatusDto(String code, String message) {
        this(code, message, null);
    }

    public StatusDto(String code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static StatusDto buildSuccess() {
        return new StatusDto(SUCCESS_CODE, SUCCESS_MSG);
    }

    public static StatusDto buildSuccess(String message) {
        return new StatusDto(SUCCESS_CODE, message);
    }

    public static <E> StatusDto<E> buildSuccess(E data) {
        return new StatusDto<E>(SUCCESS_CODE, SUCCESS_MSG, data);
    }

    public static <E> StatusDto<E> buildSuccess(String message, E data) {
        return new StatusDto<E>(SUCCESS_CODE, message, data);
    }

    public static StatusDto buildFailure() {
        return new StatusDto(FAILURE_CODE, FAILURE_MSG);
    }

    public static StatusDto buildFailure(String message) {
        return new StatusDto(FAILURE_CODE, message);
    }

    public static <E> StatusDto<E> buildFailure(E data) {
        return new StatusDto<E>(FAILURE_CODE, SUCCESS_MSG, data);
    }

    public static <E> StatusDto<E> buildFailure(String message, E data) {
        return new StatusDto<E>(FAILURE_CODE, message, data);
    }

    public static StatusDto buildWithCode(String code, String message) {
        return new StatusDto(code, message);
    }

    public static <E> StatusDto<E> buildWithCode(String code, String message, E data) {
        return new StatusDto<E>(code, message, data);
    }

    public String toString() {
        String dataString = this.data != null ? this.data.toString() : "null";
        return "{code='" + this.code + '\'' + ", message='" + this.message + '\'' + ", data=" + dataString + '}';
    }
}

