/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.handler.invoice;

import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.exception.BizException;
import com.rocogz.common.template.BaseSingleTemplate;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseOperateDetail;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEvent;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseOperateDetailMapper;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceEnterpriseDayStatisticMiddleHandler;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class InvoiceEnterpriseDayStatisticEffectSaveHandler
extends BaseSingleTemplate<InvoiceEvent, InvoiceEnterpriseOperateDetail> {
    @Autowired
    private InvoiceEnterpriseOperateDetailMapper operateDetailMapper;
    @Autowired
    private InvoiceEnterpriseDayStatisticMiddleHandler dayStatisticMiddleHandler;

    protected InvoiceEnterpriseOperateDetail callInner(CommonRequest<InvoiceEvent> request) throws Exception {
        InvoiceEvent invoiceEvent = (InvoiceEvent)request.getRequest();
        InvoiceEnterpriseOperateDetail operateDetail = new InvoiceEnterpriseOperateDetail();
        operateDetail.setBizSubjectCode(invoiceEvent.getBizSubjectCode());
        operateDetail.setBizSubjectName(invoiceEvent.getBizSubjectSimpleName());
        operateDetail.setDay(invoiceEvent.getUpdateTime().toLocalDate());
        operateDetail.setEnterpriseCode(invoiceEvent.getBasePointCode());
        operateDetail.setEnterpriseName(invoiceEvent.getBasePointSimpleName());
        operateDetail.setInvoiceAmount(invoiceEvent.getTaxAccount());
        operateDetail.setInvoiceCode(invoiceEvent.getInvoiceCode());
        operateDetail.setInvoiceNo(invoiceEvent.getInvoiceNo());
        switch (invoiceEvent.getOperation()) {
            case ARRIVE_CONFIRM: {
                operateDetail.setDay(invoiceEvent.getArriveDate());
                break;
            }
            case INVALID: {
                operateDetail.setDay(invoiceEvent.getInvalidDate());
                break;
            }
            case CONFIRM: {
                operateDetail.setDay(invoiceEvent.getBillingDate());
                break;
            }
            default: {
                throw new BizException("\u53d1\u7968\u64cd\u4f5c\u7c7b\u578b\u5f02\u5e38");
            }
        }
        operateDetail.setMonthCode(this.dayStatisticMiddleHandler.getMonthCode(operateDetail.getDay()));
        operateDetail.setWeekCode(this.dayStatisticMiddleHandler.getWeekCode(operateDetail.getDay()));
        operateDetail.setOperateTime(LocalDateTime.now());
        operateDetail.setOperateUser(invoiceEvent.getUpdateUser());
        operateDetail.setOperateName(invoiceEvent.getUpdateUserName());
        operateDetail.setRegDate(invoiceEvent.getCreateTime().toLocalDate());
        operateDetail.setYear(Integer.valueOf(operateDetail.getDay().getYear()));
        operateDetail.setOperation(invoiceEvent.getOperation());
        operateDetail.setInvoiceNature(invoiceEvent.getInvoiceNature());
        int cnt = this.operateDetailMapper.insert(operateDetail);
        Assert.isTrue((cnt > 0 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u660e\u7ec6\u4fdd\u5b58\u5931\u8d25");
        return operateDetail;
    }
}

