/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.handler.invoice;

import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.template.BaseSingleTemplate;
import com.rocoinfo.oilcard.batch.api.request.invoice.InvoiceJobReq;
import com.rocoinfo.oilcard.batch.base.common.CommonJobParam;
import com.rocoinfo.oilcard.batch.base.job.StartBatchJob;
import com.rocoinfo.oilcard.batch.dao.batch.StepExecutionStatusDao;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseOperateDetailMapper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class InvoiceEnterpriseMiddleStatisticJobStartHandler
extends BaseSingleTemplate<InvoiceJobReq, Boolean> {
    @Autowired
    @Qualifier(value="resetInvoiceEnterMiddleJob")
    private Job resetInvoiceEnterMiddleJob;
    @Autowired
    @Qualifier(value="invoiceEnterTranstionMiddleJob")
    private Job invoiceEnterTranstionMiddleJob;
    @Autowired
    @Qualifier(value="invoiceEnterDayMiddleJob")
    private Job invoiceEnterDayMiddleJob;
    @Autowired
    @Qualifier(value="invoiceEnterWeekMiddleJob")
    private Job invoiceEnterWeekMiddleJob;
    @Autowired
    @Qualifier(value="invoiceEnterMonthMiddleJob")
    private Job invoiceEnterMonthMiddleJob;
    @Autowired
    @Qualifier(value="invoiceEnterAccumulateMiddleJob")
    private Job invoiceEnterAccumulateMiddleJob;
    @Autowired
    private CommonJobParam commonJobParam;
    @Autowired
    private ThreadPoolTaskExecutor batchTaskExecutor;
    @Autowired
    private InvoiceEnterpriseOperateDetailMapper operateDetailMapper;
    @Autowired
    private StepExecutionStatusDao stepExecutionStatusDao;

    protected Boolean callInner(CommonRequest<InvoiceJobReq> request) throws Exception {
        Map<Integer, Job> jobMap = this.commonJobParam.jobNameList(this.resetInvoiceEnterMiddleJob, this.invoiceEnterTranstionMiddleJob, this.invoiceEnterDayMiddleJob, this.invoiceEnterWeekMiddleJob, this.invoiceEnterMonthMiddleJob, this.invoiceEnterAccumulateMiddleJob);
        LocalDateTime currentTime = LocalDateTime.now();
        LocalDate currentDay = LocalDate.now();
        String currentDayStr = currentDay.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String endTime = currentTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        Map<String, Object> map = this.operateDetailMapper.getStartEndDate(currentDay, currentDay);
        this.stepExecutionStatusDao.updateStepStatusToInit("resetInvoiceEnterMiddleJob");
        String startDateStr = null;
        String endDateStr = null;
        if (map != null && map.size() > 0) {
            startDateStr = map.get("start_date").toString();
            endDateStr = map.get("end_date").toString();
        } else {
            startDateStr = currentDayStr;
            endDateStr = currentDayStr;
        }
        JobParameters jobParameters = new JobParametersBuilder().addString("startDate", startDateStr).addString("endDate", endDateStr).addString("regStartDate", currentDayStr).addString("regEndDate", currentDayStr).addString("endTime", endTime).addString("key", ((InvoiceJobReq)request.getRequest()).getKey()).addLong("timeStamp", Long.valueOf(System.currentTimeMillis())).toJobParameters();
        this.batchTaskExecutor.execute((Runnable)new StartBatchJob(this.commonJobParam.getJobLauncher(), jobMap, jobParameters));
        return true;
    }
}

