/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.handler.invoice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.template.BaseSingleTemplate;
import com.rocoinfo.oilcard.batch.api.request.invoice.InvoiceJobReq;
import com.rocoinfo.oilcard.batch.base.common.CommonJobParam;
import com.rocoinfo.oilcard.batch.base.job.StartBatchJob;
import com.rocoinfo.oilcard.batch.dao.batch.StepExecutionStatusDao;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseOperateDetailMapper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class InvoiceEnterpriseStatisticJobStartHandler
extends BaseSingleTemplate<InvoiceJobReq, Boolean> {
    @Autowired
    private Job invoiceEnterpriseResetJob;
    @Autowired
    private Job invoiceEnterDayJob;
    @Autowired
    private Job invoiceEnterDayEffectJob;
    @Autowired
    private Job invoiceEnterWeekJob;
    @Autowired
    private Job invoiceEnterMonthJob;
    @Autowired
    private Job invoiceEnterTranstionJob;
    @Autowired
    private Job invoiceEnterDayVerifyJob;
    @Autowired
    private Job invoiceEnterWeekVerifyJob;
    @Autowired
    private Job invoiceEnterMonthVerifyJob;
    @Autowired
    private Job invoiceEnterAccumulateJob;
    @Autowired
    private CommonJobParam commonJobParam;
    @Autowired
    private ThreadPoolTaskExecutor batchTaskExecutor;
    @Autowired
    private InvoiceEnterpriseOperateDetailMapper operateDetailMapper;
    @Autowired
    private StepExecutionStatusDao stepExecutionStatusDao;
    @Autowired
    private ObjectMapper objectMapper;

    protected Boolean callInner(CommonRequest<InvoiceJobReq> request) throws Exception {
        LocalDate endDate;
        Map<Integer, Job> jobMap = this.commonJobParam.jobNameList(this.invoiceEnterpriseResetJob, this.invoiceEnterTranstionJob, this.invoiceEnterDayEffectJob, this.invoiceEnterDayJob, this.invoiceEnterDayVerifyJob, this.invoiceEnterWeekJob, this.invoiceEnterWeekVerifyJob, this.invoiceEnterMonthJob, this.invoiceEnterMonthVerifyJob, this.invoiceEnterAccumulateJob);
        InvoiceJobReq invoiceJobReq = (InvoiceJobReq)request.getRequest();
        LocalDate startDate = invoiceJobReq.getStartDate();
        Assert.isTrue((startDate.isBefore(endDate = invoiceJobReq.getEndDate()) || startDate.isEqual(endDate) ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f");
        Assert.isTrue((startDate.isBefore(LocalDate.now()) && endDate.isBefore(LocalDate.now()) ? 1 : 0) != 0, (String)"\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5f53\u5929\u65e5\u671f");
        Map<String, Object> map = this.operateDetailMapper.getStartEndDate(startDate, endDate);
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        String regStartDate = invoiceJobReq.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String regEndDate = invoiceJobReq.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        this.stepExecutionStatusDao.updateStepStatusToInit("invoiceEnterpriseResetJob");
        JobParameters jobParameters = new JobParametersBuilder().addString("startDate", map.get("start_date") == null ? regStartDate : map.get("start_date").toString()).addString("endDate", map.get("end_date") == null ? regEndDate : map.get("end_date").toString()).addString("regStartDate", regStartDate).addString("regEndDate", regEndDate).addString("endTime", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).addString("key", invoiceJobReq.getKey()).addLong("timeStamp", Long.valueOf(System.currentTimeMillis())).toJobParameters();
        this.batchTaskExecutor.execute((Runnable)new StartBatchJob(this.commonJobParam.getJobLauncher(), jobMap, jobParameters));
        return true;
    }
}

