/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.handler.invoice;

import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.template.BaseSingleTemplate;
import com.rocoinfo.oilcard.batch.api.entity.job.StepExecutionStatus;
import com.rocoinfo.oilcard.batch.api.request.common.JobNodesReq;
import com.rocoinfo.oilcard.batch.base.common.CommonJobParam;
import com.rocoinfo.oilcard.batch.base.job.StartBatchJob;
import com.rocoinfo.oilcard.batch.dao.batch.StepExecutionStatusDao;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class InvoiceEnterpriseStatisticSingleStartHandler
extends BaseSingleTemplate<JobNodesReq, Boolean> {
    @Autowired
    private Job invoiceEnterpriseResetJob;
    @Autowired
    private Job invoiceEnterDayEffectJob;
    @Autowired
    private Job invoiceEnterDayJob;
    @Autowired
    private Job invoiceEnterWeekJob;
    @Autowired
    private Job invoiceEnterMonthJob;
    @Autowired
    private Job invoiceEnterTranstionJob;
    @Autowired
    private Job invoiceEnterDayVerifyJob;
    @Autowired
    private Job invoiceEnterWeekVerifyJob;
    @Autowired
    private Job invoiceEnterMonthVerifyJob;
    @Autowired
    private Job invoiceEnterAccumulateJob;
    @Autowired
    private CommonJobParam commonJobParam;
    @Autowired
    private StepExecutionStatusDao stepExecutionStatusDao;
    @Autowired
    @Qualifier(value="batchTaskExecutor")
    private ThreadPoolTaskExecutor batchTaskExecutor;

    protected Boolean callInner(CommonRequest<JobNodesReq> request) throws Exception {
        this.startSingleJob((JobNodesReq)request.getRequest());
        return true;
    }

    public void startSingleJob(JobNodesReq jobNodesReq) throws Exception {
        JobParameters jobParameters = new JobParametersBuilder().addString("startDate", jobNodesReq.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).addString("endDate", jobNodesReq.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).addLong("id", jobNodesReq.getId()).addLong("timeStamp", Long.valueOf(System.currentTimeMillis())).addString("key", jobNodesReq.getKey()).toJobParameters();
        StepExecutionStatus stepExecutionStatus = this.stepExecutionStatusDao.getByPkId(jobNodesReq.getId());
        this.batchTaskExecutor.execute((Runnable)new StartBatchJob(this.commonJobParam.getJobLauncher(), this.getNextJob(stepExecutionStatus.getStepName()), jobParameters));
    }

    private Map<Integer, Job> getNextJob(String currentJob) throws Exception {
        switch (currentJob) {
            case "invoiceEnterpriseResetJob": {
                return this.commonJobParam.jobNameList(this.invoiceEnterpriseResetJob, this.invoiceEnterDayEffectJob, this.invoiceEnterTranstionJob, this.invoiceEnterDayJob, this.invoiceEnterDayVerifyJob, this.invoiceEnterWeekJob, this.invoiceEnterWeekVerifyJob, this.invoiceEnterMonthJob, this.invoiceEnterMonthVerifyJob, this.invoiceEnterAccumulateJob, this.invoiceEnterAccumulateJob);
            }
            case "invoiceEnterTranstionJob": {
                return this.commonJobParam.jobNameList(this.invoiceEnterTranstionJob, this.invoiceEnterDayEffectJob, this.invoiceEnterDayJob, this.invoiceEnterDayVerifyJob, this.invoiceEnterWeekJob, this.invoiceEnterWeekVerifyJob, this.invoiceEnterMonthJob, this.invoiceEnterMonthVerifyJob, this.invoiceEnterAccumulateJob);
            }
            case "invoiceEnterDayEffectJob": {
                return this.commonJobParam.jobNameList(this.invoiceEnterDayEffectJob, this.invoiceEnterDayJob, this.invoiceEnterDayVerifyJob, this.invoiceEnterWeekJob, this.invoiceEnterWeekVerifyJob, this.invoiceEnterMonthJob, this.invoiceEnterMonthVerifyJob, this.invoiceEnterAccumulateJob);
            }
            case "invoiceEnterDayJob": {
                return this.commonJobParam.jobNameList(this.invoiceEnterDayJob, this.invoiceEnterDayVerifyJob, this.invoiceEnterWeekJob, this.invoiceEnterWeekVerifyJob, this.invoiceEnterMonthJob, this.invoiceEnterMonthVerifyJob, this.invoiceEnterAccumulateJob);
            }
            case "invoiceEnterDayVerifyJob": {
                return this.commonJobParam.jobNameList(this.invoiceEnterDayVerifyJob, this.invoiceEnterWeekJob, this.invoiceEnterWeekVerifyJob, this.invoiceEnterMonthJob, this.invoiceEnterMonthVerifyJob, this.invoiceEnterAccumulateJob);
            }
            case "invoiceEnterWeekJob": {
                return this.commonJobParam.jobNameList(this.invoiceEnterWeekJob, this.invoiceEnterWeekVerifyJob, this.invoiceEnterMonthJob, this.invoiceEnterMonthVerifyJob, this.invoiceEnterAccumulateJob);
            }
            case "invoiceEnterWeekVerifyJob": {
                return this.commonJobParam.jobNameList(this.invoiceEnterWeekVerifyJob, this.invoiceEnterMonthJob, this.invoiceEnterMonthVerifyJob, this.invoiceEnterAccumulateJob);
            }
            case "invoiceEnterMonthJob": {
                return this.commonJobParam.jobNameList(this.invoiceEnterMonthJob, this.invoiceEnterMonthVerifyJob, this.invoiceEnterAccumulateJob, this.invoiceEnterAccumulateJob);
            }
            case "invoiceEnterMonthVerifyJob": {
                return this.commonJobParam.jobNameList(this.invoiceEnterMonthVerifyJob, this.invoiceEnterAccumulateJob, this.invoiceEnterAccumulateJob);
            }
            case "invoiceEnterAccumulateJob": {
                return this.commonJobParam.jobNameList(this.invoiceEnterAccumulateJob, this.invoiceEnterAccumulateJob);
            }
        }
        return null;
    }
}

