/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.handler.invoice;

import com.rocogz.common.api.request.CommonRequest;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseAccumulateStatisticMiddle;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseOperateDetail;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEvent;
import com.rocoinfo.oilcard.batch.api.enums.InvoiceNatureEnum;
import com.rocoinfo.oilcard.batch.api.enums.MqCustomerStatus;
import com.rocoinfo.oilcard.batch.base.utils.PingYinUtil;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseAccumulateStatisticMiddleMapper;
import com.rocoinfo.oilcard.batch.dto.InvoiceStatisticsMqPushReq;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceEnterpriseDayStatisticEffectSaveHandler;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceEnterpriseDayStatisticMiddleHandler;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceEventHandler;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceStatisticHandler;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class InvoiceStatisticConsumerHandler {
    private static final Logger log = LoggerFactory.getLogger(InvoiceStatisticConsumerHandler.class);
    @Autowired
    private InvoiceEnterpriseDayStatisticMiddleHandler dayStatisticMiddleHandler;
    @Autowired
    private InvoiceEnterpriseDayStatisticEffectSaveHandler effectSaveHandler;
    @Autowired
    private InvoiceStatisticHandler invoiceStatisticsService;
    @Autowired
    private InvoiceEnterpriseAccumulateStatisticMiddleMapper accumulateStatisticMiddleMapper;
    @Autowired
    private InvoiceEventHandler invoiceEventHandler;

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void invoiceActualStatistic(InvoiceEvent invoiceEvent, InvoiceStatisticsMqPushReq invoiceStatisticsMqPushReq) throws Exception {
        this.invoiceStatisticsService.callService(new CommonRequest(), invoiceStatisticsMqPushReq);
        if (invoiceEvent.getInvoiceNature() == InvoiceNatureEnum.BJROCO_BASE_POINT || invoiceEvent.getInvoiceNature() == InvoiceNatureEnum.GZROCO_BASE_POINT) {
            InvoiceEnterpriseAccumulateStatisticMiddle beforeAccumulateStatisticMiddle;
            CommonRequest request = new CommonRequest();
            InvoiceEnterpriseOperateDetail operateDetail = (InvoiceEnterpriseOperateDetail)this.effectSaveHandler.callService(request, invoiceEvent);
            this.dayStatisticMiddleHandler.middleStatistic(Arrays.asList(operateDetail));
            InvoiceEnterpriseAccumulateStatisticMiddle accumulateStatisticMiddleTmp = this.getAccumulateStatisticMiddle(operateDetail);
            InvoiceEnterpriseAccumulateStatisticMiddle accumulateStatisticMiddle = this.accumulateStatisticMiddleMapper.selectByEndDate(operateDetail.getRegDate(), operateDetail.getEnterpriseCode(), operateDetail.getBizSubjectCode());
            if (accumulateStatisticMiddle == null && (beforeAccumulateStatisticMiddle = this.accumulateStatisticMiddleMapper.selectByEndDate(operateDetail.getRegDate().plusDays(-1L), operateDetail.getEnterpriseCode(), operateDetail.getBizSubjectCode())) != null) {
                accumulateStatisticMiddleTmp.setTotalCnt(beforeAccumulateStatisticMiddle.getTotalCnt());
                accumulateStatisticMiddleTmp.setTotalAmount(beforeAccumulateStatisticMiddle.getTotalAmount());
                accumulateStatisticMiddleTmp.setInvalidCnt(beforeAccumulateStatisticMiddle.getInvalidCnt());
                accumulateStatisticMiddleTmp.setInvalidAmount(beforeAccumulateStatisticMiddle.getInvalidAmount());
                accumulateStatisticMiddleTmp.setArrivalCnt(beforeAccumulateStatisticMiddle.getArrivalCnt());
                accumulateStatisticMiddleTmp.setArrivalAmount(beforeAccumulateStatisticMiddle.getArrivalAmount());
            }
            this.accumulateStatisticMiddleMapper.saveOrUpdate(accumulateStatisticMiddleTmp);
            invoiceEvent.setUpdateTime(LocalDateTime.now());
            invoiceEvent.setResult(MqCustomerStatus.SUCCESS);
            this.invoiceEventHandler.callService(new CommonRequest(), invoiceEvent);
        }
    }

    public InvoiceEnterpriseAccumulateStatisticMiddle getAccumulateStatisticMiddle(InvoiceEnterpriseOperateDetail operateDetail) {
        InvoiceEnterpriseAccumulateStatisticMiddle accumulateStatisticMiddle = new InvoiceEnterpriseAccumulateStatisticMiddle();
        switch (operateDetail.getOperation()) {
            case ARRIVE_CONFIRM: {
                accumulateStatisticMiddle.setArrivalAmount(operateDetail.getInvoiceAmount());
                accumulateStatisticMiddle.setArrivalCnt(Long.valueOf(1L));
                accumulateStatisticMiddle.setInvalidAmount(BigDecimal.ZERO);
                accumulateStatisticMiddle.setInvalidCnt(Long.valueOf(0L));
                accumulateStatisticMiddle.setTotalAmount(BigDecimal.ZERO);
                accumulateStatisticMiddle.setTotalCnt(Long.valueOf(0L));
                break;
            }
            case INVALID: {
                accumulateStatisticMiddle.setInvalidAmount(operateDetail.getInvoiceAmount());
                accumulateStatisticMiddle.setInvalidCnt(Long.valueOf(1L));
                accumulateStatisticMiddle.setTotalAmount(BigDecimal.ZERO);
                accumulateStatisticMiddle.setTotalCnt(Long.valueOf(0L));
                accumulateStatisticMiddle.setArrivalAmount(BigDecimal.ZERO);
                accumulateStatisticMiddle.setArrivalCnt(Long.valueOf(0L));
                break;
            }
            case CONFIRM: {
                accumulateStatisticMiddle.setTotalAmount(operateDetail.getInvoiceAmount());
                accumulateStatisticMiddle.setTotalCnt(Long.valueOf(1L));
                accumulateStatisticMiddle.setArrivalAmount(BigDecimal.ZERO);
                accumulateStatisticMiddle.setArrivalCnt(Long.valueOf(0L));
                accumulateStatisticMiddle.setInvalidAmount(BigDecimal.ZERO);
                accumulateStatisticMiddle.setInvalidCnt(Long.valueOf(0L));
            }
        }
        accumulateStatisticMiddle.setBizSubjectCode(operateDetail.getBizSubjectCode());
        accumulateStatisticMiddle.setBizSubjectName(operateDetail.getBizSubjectName());
        accumulateStatisticMiddle.setEnterpriseCode(operateDetail.getEnterpriseCode());
        accumulateStatisticMiddle.setEnterpriseName(operateDetail.getEnterpriseName());
        accumulateStatisticMiddle.setEnterpriseNamePinyin(PingYinUtil.getPingYin(operateDetail.getEnterpriseName()));
        accumulateStatisticMiddle.setInvoiceNature(operateDetail.getInvoiceNature());
        accumulateStatisticMiddle.setEndDate(operateDetail.getRegDate());
        accumulateStatisticMiddle.setStatisticDay(LocalDate.now());
        accumulateStatisticMiddle.setStatisticTime(LocalDateTime.now());
        return accumulateStatisticMiddle;
    }

    @Transactional(rollbackFor={Exception.class})
    public void invoiceConsumer(InvoiceEvent invoiceEvent, InvoiceStatisticsMqPushReq invoiceStatisticsMqPushReq) throws Exception {
        try {
            InvoiceStatisticConsumerHandler handler = (InvoiceStatisticConsumerHandler)AopContext.currentProxy();
            handler.invoiceActualStatistic(invoiceEvent, invoiceStatisticsMqPushReq);
            log.info("\u5f00\u7968\u7edf\u8ba1MQ\u6d88\u8d39\u5b8c\u6210,\u53d1\u7968\u7533\u8bf7\u5355\u53f7:{}", (Object)invoiceStatisticsMqPushReq.getApplyCode());
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("Duplicate")) {
                log.info("\u91cd\u590d\u7684\u5f00\u7968\u6d88\u606fmsgId:{}", (Object)invoiceStatisticsMqPushReq.getMsgId());
            }
            log.error("\u6d88\u8d39MQ\u5bf9\u516c\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            invoiceEvent.setResult(MqCustomerStatus.FAIL);
            invoiceEvent.setResultMsg(this.invoiceStatisticsService.getErrorMsg(e));
            invoiceEvent.setUpdateTime(LocalDateTime.now());
            this.invoiceEventHandler.callService(new CommonRequest(), invoiceEvent);
        }
    }
}

