/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.job.invoice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseAccumulateStatistic;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseAccumulateStatisticMiddle;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseDayStatistic;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseDayStatisticMiddle;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseDayTranstionStatisticMiddle;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseMonthStatistic;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseMonthStatisticMiddle;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseOperateDetail;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseWeekStatistic;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseWeekStatisticMiddle;
import com.rocoinfo.oilcard.batch.api.enums.InvoiceNatureEnum;
import com.rocoinfo.oilcard.batch.api.request.common.BizSubject;
import com.rocoinfo.oilcard.batch.api.request.common.EnterpriseBasePoint;
import com.rocoinfo.oilcard.batch.api.request.invoice.InvoiceJobReq;
import com.rocoinfo.oilcard.batch.base.listener.BatchJobListener;
import com.rocoinfo.oilcard.batch.base.utils.PingYinUtil;
import com.rocoinfo.oilcard.batch.config.BatchBizSubjectConfig;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseAccumulateStatisticMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseAccumulateStatisticMiddleMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseDayStatisticMiddleMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseDayTranstionStatisticMiddleMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseMonthStatisticMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseMonthStatisticMiddleMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseWeekStatisticMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseWeekStatisticMiddleMapper;
import com.rocoinfo.oilcard.batch.dto.InvoiceEnterpriseDayStatisticDTO;
import com.rocoinfo.oilcard.batch.dto.InvoiceEnterpriseMonthStatisticDTO;
import com.rocoinfo.oilcard.batch.dto.InvoiceEnterpriseWeekStatisticDTO;
import com.rocoinfo.oilcard.batch.handler.batch.StepExecutionStatusHandler;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceEnterpriseDayStatisticHandler;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceEnterpriseDayStatisticMiddleHandler;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import tk.mybatis.mapper.entity.Example;

@Configuration
public class InvoiceEnterpriseMiddleStatisticJobConfig {
    private static final Logger log = LoggerFactory.getLogger(InvoiceEnterpriseMiddleStatisticJobConfig.class);
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Autowired
    private StepExecutionStatusHandler stepExecutionStatusService;
    @Autowired
    private DataSource dataSource;
    @Autowired
    @Qualifier(value="invoiceEventEnterItemReader")
    private ItemReader<InvoiceEnterpriseOperateDetail> invoiceEventEnterItemReader;
    @Autowired
    @Qualifier(value="transtionDayMiddleItemWriter")
    private ItemWriter<InvoiceEnterpriseOperateDetail> transtionDayMiddleItemWriter;
    @Autowired
    @Qualifier(value="batchTaskExecutor")
    private ThreadPoolTaskExecutor batchTaskExecutor;
    @Autowired
    private InvoiceEnterpriseDayStatisticMiddleHandler dayStatisticMiddleHandler;
    @Autowired
    private InvoiceEnterpriseDayStatisticMiddleMapper dayStatisticMiddleMapper;
    @Autowired
    private InvoiceEnterpriseWeekStatisticMiddleMapper weekStatisticMiddleMapper;
    @Autowired
    private InvoiceEnterpriseMonthStatisticMiddleMapper monthStatisticMiddleMapper;
    @Autowired
    private InvoiceEnterpriseDayTranstionStatisticMiddleMapper dayTranstionStatisticMiddleMapper;
    @Autowired
    private InvoiceEnterpriseAccumulateStatisticMiddleMapper accumulateStatisticMiddleMapper;
    @Autowired
    private InvoiceEnterpriseDayStatisticHandler dayStatisticHandler;
    @Autowired
    private InvoiceEnterpriseWeekStatisticMapper weekStatisticMapper;
    @Autowired
    private InvoiceEnterpriseMonthStatisticMapper monthStatisticMapper;
    @Autowired
    private InvoiceEnterpriseAccumulateStatisticMapper accumulateStatisticMapper;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private BatchBizSubjectConfig bizSubjectConfig;

    @Bean(value={"resetInvoiceEnterMiddleJob"})
    public Job resetInvoiceEnterMiddleJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("resetInvoiceEnterMiddleJob").start(this.resetInvoiceEnterMiddleStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step resetInvoiceEnterMiddleStep() {
        return this.stepBuilderFactory.get("resetInvoiceEnterMiddleStep").tasklet(new Tasklet(){

            public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
                LocalDate currentDate = LocalDate.now();
                Map map = chunkContext.getStepContext().getJobParameters();
                LocalDate startDate = LocalDate.parse(map.get("startDate").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                LocalDate endDate = LocalDate.parse(map.get("endDate").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                LocalDate regStartDate = LocalDate.parse(map.get("regStartDate").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                String key = map.get("key").toString();
                Integer startWeekCode = InvoiceEnterpriseMiddleStatisticJobConfig.this.dayStatisticMiddleHandler.getWeekCode(startDate);
                Integer endWeekCode = InvoiceEnterpriseMiddleStatisticJobConfig.this.dayStatisticMiddleHandler.getWeekCode(endDate);
                Integer startMonthCode = InvoiceEnterpriseMiddleStatisticJobConfig.this.dayStatisticMiddleHandler.getMonthCode(startDate);
                Integer endMonthCode = InvoiceEnterpriseMiddleStatisticJobConfig.this.dayStatisticMiddleHandler.getMonthCode(endDate);
                InvoiceEnterpriseMiddleStatisticJobConfig.this.dayTranstionStatisticMiddleMapper.deleteAll();
                InvoiceEnterpriseMiddleStatisticJobConfig.this.deleteInvoiceEnterDayMiddle(startDate, endDate);
                InvoiceEnterpriseMiddleStatisticJobConfig.this.deleteInvoiceEnterWeekMiddle(startWeekCode, endWeekCode);
                InvoiceEnterpriseMiddleStatisticJobConfig.this.deleteInvoiceEnterMonthMiddle(startMonthCode, endMonthCode);
                InvoiceEnterpriseMiddleStatisticJobConfig.this.deleteInvoiceEnterEndDateMiddle(regStartDate);
                List<InvoiceEnterpriseDayStatistic> dayStatistics = InvoiceEnterpriseMiddleStatisticJobConfig.this.dayStatisticHandler.selectEnterDayList(startDate, endDate);
                ArrayList<InvoiceEnterpriseDayStatisticMiddle> dayStatisticMiddles = new ArrayList<InvoiceEnterpriseDayStatisticMiddle>();
                for (InvoiceEnterpriseDayStatistic dayStatistic : dayStatistics) {
                    InvoiceEnterpriseDayStatisticMiddle dayStatisticMiddle = new InvoiceEnterpriseDayStatisticMiddle();
                    BeanUtils.copyProperties((Object)dayStatistic, (Object)dayStatisticMiddle);
                    dayStatisticMiddles.add(dayStatisticMiddle);
                }
                if (dayStatisticMiddles != null && dayStatisticMiddles.size() > 0) {
                    InvoiceEnterpriseMiddleStatisticJobConfig.this.dayStatisticMiddleMapper.batchSaveOrUpdate(dayStatisticMiddles);
                }
                Example weekExample = new Example(InvoiceEnterpriseWeekStatistic.class);
                Example.Criteria weekCriteria = weekExample.createCriteria();
                weekCriteria.andBetween("weekCode", (Object)startWeekCode, (Object)endWeekCode);
                List weekStatisticList = InvoiceEnterpriseMiddleStatisticJobConfig.this.weekStatisticMapper.selectByExample(weekExample);
                ArrayList<InvoiceEnterpriseWeekStatisticMiddle> weekStatisticMiddles = new ArrayList<InvoiceEnterpriseWeekStatisticMiddle>();
                for (InvoiceEnterpriseWeekStatistic weekStatistic : weekStatisticList) {
                    InvoiceEnterpriseWeekStatisticMiddle weekStatisticMiddle = new InvoiceEnterpriseWeekStatisticMiddle();
                    BeanUtils.copyProperties((Object)weekStatistic, (Object)weekStatisticMiddle);
                    weekStatisticMiddles.add(weekStatisticMiddle);
                }
                if (weekStatisticMiddles != null && weekStatisticMiddles.size() > 0) {
                    InvoiceEnterpriseMiddleStatisticJobConfig.this.weekStatisticMiddleMapper.batchSaveOrUpdate(weekStatisticMiddles);
                }
                Example monthExample = new Example(InvoiceEnterpriseMonthStatistic.class);
                Example.Criteria monthCriteria = monthExample.createCriteria();
                monthCriteria.andBetween("monthCode", (Object)startMonthCode, (Object)endMonthCode);
                List monthStatisticList = InvoiceEnterpriseMiddleStatisticJobConfig.this.monthStatisticMapper.selectByExample(monthExample);
                ArrayList<InvoiceEnterpriseMonthStatisticMiddle> monthStatisticMiddleList = new ArrayList<InvoiceEnterpriseMonthStatisticMiddle>();
                for (InvoiceEnterpriseMonthStatistic monthStatistic : monthStatisticList) {
                    InvoiceEnterpriseMonthStatisticMiddle monthStatisticMiddle = new InvoiceEnterpriseMonthStatisticMiddle();
                    BeanUtils.copyProperties((Object)monthStatistic, (Object)monthStatisticMiddle);
                    monthStatisticMiddleList.add(monthStatisticMiddle);
                }
                if (monthStatisticMiddleList != null && monthStatisticMiddleList.size() > 0) {
                    InvoiceEnterpriseMiddleStatisticJobConfig.this.monthStatisticMiddleMapper.batchSaveOrUpdate(monthStatisticMiddleList);
                }
                InvoiceEnterpriseMiddleStatisticJobConfig.this.getDefault(startDate, endDate, key);
                return RepeatStatus.FINISHED;
            }
        }).build();
    }

    private void deleteInvoiceEnterDayMiddle(LocalDate startDate, LocalDate endDate) {
        Example dayMiddleExample = new Example(InvoiceEnterpriseDayStatisticMiddle.class);
        Example.Criteria dayMiddleCriteria = dayMiddleExample.createCriteria();
        dayMiddleCriteria.andBetween("day", (Object)startDate, (Object)endDate);
        this.dayStatisticMiddleMapper.deleteByExample(dayMiddleExample);
    }

    private void deleteInvoiceEnterWeekMiddle(Integer startWeekCode, Integer endWeekCode) {
        Example weekMiddleExample = new Example(InvoiceEnterpriseWeekStatisticMiddle.class);
        Example.Criteria weekMiddleCriteria = weekMiddleExample.createCriteria();
        weekMiddleCriteria.andBetween("weekCode", (Object)startWeekCode, (Object)endWeekCode);
        this.weekStatisticMiddleMapper.deleteByExample(weekMiddleExample);
    }

    private void deleteInvoiceEnterMonthMiddle(Integer startMonthCode, Integer endMonthCode) {
        Example monthMiddleExample = new Example(InvoiceEnterpriseMonthStatisticMiddle.class);
        Example.Criteria monthMiddleCriteria = monthMiddleExample.createCriteria();
        monthMiddleCriteria.andBetween("monthCode", (Object)startMonthCode, (Object)endMonthCode);
        this.monthStatisticMiddleMapper.deleteByExample(monthMiddleExample);
    }

    private void deleteInvoiceEnterEndDateMiddle(LocalDate regStartDate) {
        Example accumulateExample = new Example(InvoiceEnterpriseAccumulateStatisticMiddle.class);
        Example.Criteria accumulateExampleCriteria = accumulateExample.createCriteria();
        accumulateExampleCriteria.andEqualTo("endDate", (Object)regStartDate);
        this.accumulateStatisticMiddleMapper.deleteByExample(accumulateExample);
    }

    @Bean(value={"invoiceEnterDayMiddleJob"})
    public Job invoiceEnterDayMiddleJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterDayMiddleJob").start(this.invoiceEnterDayMiddleStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterDayMiddleStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("invoiceEnterDayMiddleStep").tasklet((stepContribution, chunkContext) -> {
            List<InvoiceEnterpriseDayTranstionStatisticMiddle> dayTranstionStatisticMiddles = this.dayTranstionStatisticMiddleMapper.selectDayMiddleStatistic();
            ArrayList<InvoiceEnterpriseDayStatisticMiddle> dayStatisticMiddles = new ArrayList<InvoiceEnterpriseDayStatisticMiddle>();
            for (InvoiceEnterpriseDayTranstionStatisticMiddle dayTranstionStatisticMiddle : dayTranstionStatisticMiddles) {
                InvoiceEnterpriseDayStatisticMiddle dayStatisticMiddle = new InvoiceEnterpriseDayStatisticMiddle();
                BeanUtils.copyProperties((Object)dayTranstionStatisticMiddle, (Object)dayStatisticMiddle);
                dayStatisticMiddle.setStatisticDay(LocalDate.now());
                dayStatisticMiddle.setStatisticTime(LocalDateTime.now());
                dayStatisticMiddles.add(dayStatisticMiddle);
            }
            if (dayStatisticMiddles.size() > 0) {
                this.dayStatisticMiddleMapper.batchRealSaveOrUpdate(dayStatisticMiddles);
            }
            return RepeatStatus.FINISHED;
        }).allowStartIfComplete(true)).build();
    }

    @Bean(value={"invoiceEnterWeekMiddleJob"})
    public Job invoiceEnterWeekMiddleJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterWeekMiddleJob").start(this.invoiceEnterWeekMiddleStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterWeekMiddleStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("invoiceEnterWeekMiddleStep").tasklet((stepContribution, chunkContext) -> {
            Map map = chunkContext.getStepContext().getJobParameters();
            String regDateStr = (String)map.get("regStartDate");
            LocalDate regDate = LocalDate.parse(regDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            List<InvoiceEnterpriseDayTranstionStatisticMiddle> dayStatisticMiddles = this.dayTranstionStatisticMiddleMapper.selectByRegDate(regDate);
            ArrayList<InvoiceEnterpriseDayStatisticDTO> dtos = new ArrayList<InvoiceEnterpriseDayStatisticDTO>();
            for (InvoiceEnterpriseDayTranstionStatisticMiddle dayStatisticMiddle : dayStatisticMiddles) {
                InvoiceEnterpriseDayStatisticDTO dto = new InvoiceEnterpriseDayStatisticDTO();
                BeanUtils.copyProperties((Object)dayStatisticMiddle, (Object)dto);
                dtos.add(dto);
            }
            List<InvoiceEnterpriseWeekStatisticDTO> weekStatisticDTOS = this.dayStatisticMiddleHandler.getWeekStatistic(dtos);
            ArrayList<InvoiceEnterpriseWeekStatisticMiddle> weekStatisticMiddles = new ArrayList<InvoiceEnterpriseWeekStatisticMiddle>();
            for (InvoiceEnterpriseWeekStatisticDTO weekStatisticDTO : weekStatisticDTOS) {
                InvoiceEnterpriseWeekStatisticMiddle weekStatisticMiddle = new InvoiceEnterpriseWeekStatisticMiddle();
                BeanUtils.copyProperties((Object)weekStatisticDTO, (Object)weekStatisticMiddle);
                weekStatisticMiddle.setStatisticDay(LocalDate.now());
                weekStatisticMiddle.setStatisticTime(LocalDateTime.now());
                weekStatisticMiddles.add(weekStatisticMiddle);
            }
            if (weekStatisticMiddles != null && weekStatisticMiddles.size() > 0) {
                this.weekStatisticMiddleMapper.batchRealSaveOrUpdate(weekStatisticMiddles);
            }
            return RepeatStatus.FINISHED;
        }).allowStartIfComplete(true)).build();
    }

    @Bean(value={"invoiceEnterAccumulateMiddleJob"})
    public Job invoiceEnterAccumulateMiddleJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterAccumulateMiddleJob").start(this.invoiceEnterAccumulateMiddleStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterAccumulateMiddleStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("invoiceEnterAccumulateMiddleStep").tasklet((stepContribution, chunkContext) -> {
            Map map = chunkContext.getStepContext().getJobParameters();
            if (map.get("regStartDate") != null && map.get("regEndDate") != null) {
                LocalDate regStartDate = LocalDate.parse(map.get("regStartDate").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                List<InvoiceEnterpriseDayTranstionStatisticMiddle> invoiceEnterpriseDayTranstionStatisticMiddles = this.dayTranstionStatisticMiddleMapper.statisticByRegDate(regStartDate);
                ArrayList<InvoiceEnterpriseAccumulateStatisticMiddle> accumulateStatisticMiddles = new ArrayList<InvoiceEnterpriseAccumulateStatisticMiddle>();
                for (InvoiceEnterpriseDayTranstionStatisticMiddle dayTranstionStatisticMiddle : invoiceEnterpriseDayTranstionStatisticMiddles) {
                    InvoiceEnterpriseAccumulateStatisticMiddle middle = new InvoiceEnterpriseAccumulateStatisticMiddle();
                    BeanUtils.copyProperties((Object)dayTranstionStatisticMiddle, (Object)middle);
                    middle.setEnterpriseNamePinyin(PingYinUtil.getPingYin(dayTranstionStatisticMiddle.getEnterpriseName()));
                    middle.setEndDate(dayTranstionStatisticMiddle.getRegDate());
                    InvoiceEnterpriseAccumulateStatistic accumulateStatistic = this.accumulateStatisticMapper.selectLastEndDateData(middle.getEndDate().plusDays(-1L), middle.getEnterpriseCode(), middle.getBizSubjectCode());
                    if (accumulateStatistic != null) {
                        middle.setArrivalAmount(middle.getArrivalAmount().add(accumulateStatistic.getArrivalAmount()));
                        middle.setArrivalCnt(Long.valueOf(middle.getArrivalCnt() + accumulateStatistic.getArrivalCnt()));
                        middle.setInvalidAmount(middle.getInvalidAmount().add(accumulateStatistic.getInvalidAmount()));
                        middle.setInvalidCnt(Long.valueOf(middle.getInvalidCnt() + accumulateStatistic.getInvalidCnt()));
                        middle.setTotalAmount(middle.getTotalAmount().add(accumulateStatistic.getTotalAmount()));
                        middle.setTotalCnt(Long.valueOf(middle.getTotalCnt() + accumulateStatistic.getTotalCnt()));
                    }
                    accumulateStatisticMiddles.add(middle);
                }
                if (accumulateStatisticMiddles.size() > 0) {
                    this.accumulateStatisticMiddleMapper.batchSaveOrUpdate(accumulateStatisticMiddles);
                }
            }
            return RepeatStatus.FINISHED;
        }).allowStartIfComplete(true)).build();
    }

    @Bean(value={"invoiceEnterMonthMiddleJob"})
    public Job invoiceEnterMonthMiddleJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterMonthMiddleJob").start(this.invoiceEnterMonthMiddleStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterMonthMiddleStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("invoiceEnterMonthMiddleStep").tasklet((stepContribution, chunkContext) -> {
            Map map = chunkContext.getStepContext().getJobParameters();
            String regDateStr = (String)map.get("regStartDate");
            LocalDate regDate = LocalDate.parse(regDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            List<InvoiceEnterpriseDayTranstionStatisticMiddle> dayStatisticMiddles = this.dayTranstionStatisticMiddleMapper.selectByRegDate(regDate);
            ArrayList<InvoiceEnterpriseDayStatisticDTO> dtos = new ArrayList<InvoiceEnterpriseDayStatisticDTO>();
            for (InvoiceEnterpriseDayTranstionStatisticMiddle dayStatisticMiddle : dayStatisticMiddles) {
                InvoiceEnterpriseDayStatisticDTO dto = new InvoiceEnterpriseDayStatisticDTO();
                BeanUtils.copyProperties((Object)dayStatisticMiddle, (Object)dto);
                dtos.add(dto);
            }
            List<InvoiceEnterpriseMonthStatisticDTO> monthStatisticDTOList = this.dayStatisticMiddleHandler.getMonthStatistic(dtos);
            ArrayList<InvoiceEnterpriseMonthStatisticMiddle> monthStatisticMiddles = new ArrayList<InvoiceEnterpriseMonthStatisticMiddle>();
            for (InvoiceEnterpriseMonthStatisticDTO monthStatisticDTO : monthStatisticDTOList) {
                InvoiceEnterpriseMonthStatisticMiddle monthStatisticMiddle = new InvoiceEnterpriseMonthStatisticMiddle();
                BeanUtils.copyProperties((Object)monthStatisticDTO, (Object)monthStatisticMiddle);
                monthStatisticMiddle.setStatisticDay(LocalDate.now());
                monthStatisticMiddle.setStatisticTime(LocalDateTime.now());
                monthStatisticMiddles.add(monthStatisticMiddle);
            }
            if (monthStatisticMiddles != null && monthStatisticMiddles.size() > 0) {
                this.monthStatisticMiddleMapper.batchRealSaveOrUpdate(monthStatisticMiddles);
            }
            return RepeatStatus.FINISHED;
        }).allowStartIfComplete(true)).build();
    }

    @Bean(value={"invoiceEnterTranstionMiddleJob"})
    public Job invoiceEnterTranstionMiddleJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterTranstionMiddleJob").start(this.invoiceEnterTranstionMiddleStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterTranstionMiddleStep() {
        return this.stepBuilderFactory.get("invoiceEnterTranstionMiddleStep").chunk(1000).reader(this.invoiceEventEnterItemReader).writer(this.transtionDayMiddleItemWriter).taskExecutor((TaskExecutor)this.batchTaskExecutor).throttleLimit(2).build();
    }

    public void getDefault(LocalDate startDate, LocalDate endDate, String key) throws Exception {
        InvoiceJobReq invoiceJobReq = (InvoiceJobReq)this.objectMapper.readValue((String)this.redisTemplate.opsForValue().get((Object)key), InvoiceJobReq.class);
        List enterpriseBasePoints = invoiceJobReq.getBasePointList();
        List bizSubjects = invoiceJobReq.getBizSubjects();
        Long dayCnt = endDate.toEpochDay() - startDate.toEpochDay();
        Long i = 0L;
        while (i <= dayCnt) {
            ArrayList<InvoiceEnterpriseDayTranstionStatisticMiddle> dayTranstionStatisticsMiddle = new ArrayList<InvoiceEnterpriseDayTranstionStatisticMiddle>();
            LocalDate day = startDate.plusDays(i);
            for (BizSubject bizSubject : bizSubjects) {
                for (EnterpriseBasePoint enterpriseBasePoint : enterpriseBasePoints) {
                    InvoiceEnterpriseDayTranstionStatisticMiddle dayTranstionStatisticMiddle = new InvoiceEnterpriseDayTranstionStatisticMiddle();
                    dayTranstionStatisticMiddle.setStatisticDay(LocalDate.now());
                    if (bizSubject.getBizSubjectCode().equals(this.bizSubjectConfig.getGzcode())) {
                        dayTranstionStatisticMiddle.setInvoiceNature(InvoiceNatureEnum.GZROCO_BASE_POINT);
                    } else if (bizSubject.getBizSubjectCode().equals(this.bizSubjectConfig.getBjcode())) {
                        dayTranstionStatisticMiddle.setInvoiceNature(InvoiceNatureEnum.BJROCO_BASE_POINT);
                    }
                    dayTranstionStatisticMiddle.setEnterpriseCode(enterpriseBasePoint.getEnterpriseCode());
                    dayTranstionStatisticMiddle.setEnterpriseName(enterpriseBasePoint.getEnterpriseName());
                    dayTranstionStatisticMiddle.setBizSubjectCode(bizSubject.getBizSubjectCode());
                    dayTranstionStatisticMiddle.setBizSubjectName(bizSubject.getBizSubjectName());
                    dayTranstionStatisticMiddle.setMonth(Integer.valueOf(day.getMonthValue()));
                    dayTranstionStatisticMiddle.setRegDate(day);
                    dayTranstionStatisticMiddle.setStatisticTime(LocalDateTime.now());
                    dayTranstionStatisticMiddle.setWeekCode(this.dayStatisticMiddleHandler.getWeekCode(day));
                    dayTranstionStatisticMiddle.setYear(Integer.valueOf(day.getYear()));
                    dayTranstionStatisticMiddle.setArrivalAmount(BigDecimal.ZERO);
                    dayTranstionStatisticMiddle.setArrivalCnt(Long.valueOf(0L));
                    dayTranstionStatisticMiddle.setInvalidAmount(BigDecimal.ZERO);
                    dayTranstionStatisticMiddle.setInvalidCnt(Long.valueOf(0L));
                    dayTranstionStatisticMiddle.setTotalAmount(BigDecimal.ZERO);
                    dayTranstionStatisticMiddle.setTotalCnt(Long.valueOf(0L));
                    dayTranstionStatisticMiddle.setDay(day);
                    dayTranstionStatisticsMiddle.add(dayTranstionStatisticMiddle);
                }
            }
            this.dayTranstionStatisticMiddleMapper.batchSaveOrUpdate(dayTranstionStatisticsMiddle);
            Long l = i;
            Long l2 = i = Long.valueOf(i + 1L);
        }
    }

    @Bean(value={"transtionDayMiddleItemWriter"})
    @StepScope
    public ItemWriter<InvoiceEnterpriseOperateDetail> transtionDayMiddleItemWriter() {
        try {
            ItemWriter<InvoiceEnterpriseOperateDetail> itemWriter = new ItemWriter<InvoiceEnterpriseOperateDetail>(){

                public void write(List<? extends InvoiceEnterpriseOperateDetail> list) throws Exception {
                    log.info("\u5f00\u59cb\u5904\u7406\u6bcf\u9875\u6570\u636e\u5927\u5c0f\uff1a{}", (Object)list.size());
                    List<InvoiceEnterpriseDayStatisticDTO> dtos = InvoiceEnterpriseMiddleStatisticJobConfig.this.dayStatisticMiddleHandler.getDayStatistic(list);
                    ArrayList<InvoiceEnterpriseDayTranstionStatisticMiddle> dayStatisticMiddles = new ArrayList<InvoiceEnterpriseDayTranstionStatisticMiddle>();
                    for (InvoiceEnterpriseDayStatisticDTO dto : dtos) {
                        InvoiceEnterpriseDayTranstionStatisticMiddle dayTranstionStatisticMiddle = new InvoiceEnterpriseDayTranstionStatisticMiddle();
                        BeanUtils.copyProperties((Object)dto, (Object)dayTranstionStatisticMiddle);
                        LocalDate day = dto.getDay();
                        dayTranstionStatisticMiddle.setYear(Integer.valueOf(day.getYear()));
                        dayTranstionStatisticMiddle.setMonth(Integer.valueOf(day.getMonthValue()));
                        dayTranstionStatisticMiddle.setWeekCode(InvoiceEnterpriseMiddleStatisticJobConfig.this.dayStatisticMiddleHandler.getWeekCode(day));
                        dayTranstionStatisticMiddle.setStatisticDay(LocalDate.now());
                        dayTranstionStatisticMiddle.setStatisticTime(LocalDateTime.now());
                        dayTranstionStatisticMiddle.setRegDate(dto.getRegDate());
                        dayStatisticMiddles.add(dayTranstionStatisticMiddle);
                    }
                    if (dayStatisticMiddles.size() > 0) {
                        InvoiceEnterpriseMiddleStatisticJobConfig.this.dayTranstionStatisticMiddleMapper.batchSaveOrUpdate(dayStatisticMiddles);
                    }
                }
            };
            return itemWriter;
        }
        catch (Exception e) {
            log.error("\u53d1\u7968\u65e5\u95f4\u7edf\u8ba1\u6279\u5904\u7406\u8fc7\u6e21\u6570\u636e\u5165\u5e93\u5931\u8d25:{}", (Throwable)e);
            return null;
        }
    }
}

