/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.job.invoice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseAccumulateStatistic;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseAccumulateStatisticMiddle;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseDayStatistic;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseDayStatisticEffect;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseDayStatisticMiddle;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseDayStatisticVerify;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseDayTranstionStatistic;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseMonthStatistic;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseMonthStatisticMiddle;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseOperateDetail;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseWeekStatistic;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseWeekStatisticMiddle;
import com.rocoinfo.oilcard.batch.api.enums.InvoiceNatureEnum;
import com.rocoinfo.oilcard.batch.api.enums.InvoiceOperateEnum;
import com.rocoinfo.oilcard.batch.api.request.common.BizSubject;
import com.rocoinfo.oilcard.batch.api.request.common.EnterpriseBasePoint;
import com.rocoinfo.oilcard.batch.api.request.invoice.InvoiceJobReq;
import com.rocoinfo.oilcard.batch.base.listener.BatchJobListener;
import com.rocoinfo.oilcard.batch.base.utils.PingYinUtil;
import com.rocoinfo.oilcard.batch.config.BatchBizSubjectConfig;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseAccumulateStatisticMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseAccumulateStatisticMiddleMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseDayStatisticEffectMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseDayStatisticMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseDayStatisticMiddleMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseDayStatisticVerifyMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseDayTranstionStatisticMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseMonthStatisticMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseWeekStatisticMapper;
import com.rocoinfo.oilcard.batch.dto.InvoiceEnterpriseDayStatisticDTO;
import com.rocoinfo.oilcard.batch.handler.batch.StepExecutionStatusHandler;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceEnterpriseDayStatisticHandler;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceEnterpriseDayStatisticMiddleHandler;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.JdbcPagingItemReader;
import org.springframework.batch.item.database.Order;
import org.springframework.batch.item.database.PagingQueryProvider;
import org.springframework.batch.item.database.support.MySqlPagingQueryProvider;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import tk.mybatis.mapper.entity.Example;

@Configuration
public class InvoiceEnterpriseStatisticJobConfig {
    private static final Logger log = LoggerFactory.getLogger(InvoiceEnterpriseStatisticJobConfig.class);
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Autowired
    private StepExecutionStatusHandler stepExecutionStatusService;
    @Autowired
    private DataSource dataSource;
    @Autowired
    @Qualifier(value="invoiceEventEnterItemReader")
    private ItemReader<InvoiceEnterpriseOperateDetail> invoiceEventEnterItemReader;
    @Autowired
    @Qualifier(value="transtionDayItemWriter")
    private ItemWriter<InvoiceEnterpriseOperateDetail> transtionDayItemWriter;
    @Autowired
    @Qualifier(value="batchTaskExecutor")
    private ThreadPoolTaskExecutor batchTaskExecutor;
    @Autowired
    private InvoiceEnterpriseDayStatisticMiddleHandler dayStatisticMiddleHandler;
    @Autowired
    private InvoiceEnterpriseDayStatisticMapper dayStatisticMapper;
    @Autowired
    private InvoiceEnterpriseWeekStatisticMapper weekStatisticMapper;
    @Autowired
    private InvoiceEnterpriseMonthStatisticMapper monthStatisticMapper;
    @Autowired
    private InvoiceEnterpriseDayTranstionStatisticMapper dayTranstionStatisticMapper;
    @Autowired
    private InvoiceEnterpriseDayStatisticHandler dayStatisticHandler;
    @Autowired
    private InvoiceEnterpriseDayStatisticEffectMapper dayStatisticEffectMapper;
    @Autowired
    private InvoiceEnterpriseAccumulateStatisticMapper accumulateStatisticMapper;
    @Autowired
    private InvoiceEnterpriseAccumulateStatisticMiddleMapper accumulateStatisticMiddleMapper;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private BatchBizSubjectConfig bizSubjectConfig;
    @Autowired
    private InvoiceEnterpriseDayStatisticVerifyMapper dayStatisticVerifyMapper;
    @Autowired
    private InvoiceEnterpriseDayStatisticMiddleMapper dayStatisticMiddleMapper;

    @Bean(value={"invoiceEnterpriseResetJob"})
    public Job invoiceEnterpriseResetJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterpriseResetJob").start(this.invoiceEnterpriseResetStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterpriseResetStep() {
        return this.stepBuilderFactory.get("invoiceEnterpriseResetStep").tasklet(new Tasklet(){

            public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
                Map map = chunkContext.getStepContext().getJobParameters();
                LocalDate regStartDate = LocalDate.parse(map.get("regStartDate").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                LocalDate regEndDate = LocalDate.parse(map.get("regEndDate").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                String key = map.get("key").toString();
                InvoiceEnterpriseStatisticJobConfig.this.dayTranstionStatisticMapper.deleteAll();
                if (map.get("startDate") != null && map.get("endDate") != null) {
                    LocalDate startDate = LocalDate.parse(map.get("startDate").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    LocalDate endDate = LocalDate.parse(map.get("endDate").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    InvoiceEnterpriseStatisticJobConfig.this.deleteInvoiceEnterDay(startDate, endDate);
                    Integer startWeekCode = InvoiceEnterpriseStatisticJobConfig.this.dayStatisticMiddleHandler.getWeekCode(startDate);
                    Integer endWeekCode = InvoiceEnterpriseStatisticJobConfig.this.dayStatisticMiddleHandler.getWeekCode(endDate);
                    InvoiceEnterpriseStatisticJobConfig.this.deleteInvoiceEnterWeek(startWeekCode, endWeekCode);
                    Integer startMonthCode = InvoiceEnterpriseStatisticJobConfig.this.dayStatisticMiddleHandler.getMonthCode(startDate);
                    Integer endMonthCode = InvoiceEnterpriseStatisticJobConfig.this.dayStatisticMiddleHandler.getMonthCode(endDate);
                    InvoiceEnterpriseStatisticJobConfig.this.deleteInvoiceEnterMonth(startMonthCode, endMonthCode);
                }
                InvoiceEnterpriseStatisticJobConfig.this.deleteInvoiceEnterEffectDay(regStartDate, regEndDate);
                InvoiceEnterpriseStatisticJobConfig.this.getDefault(regStartDate, regEndDate, key);
                return RepeatStatus.FINISHED;
            }
        }).build();
    }

    private void deleteInvoiceEnterEffectDay(LocalDate regStartDate, LocalDate regEndDate) {
        Example dayExample = new Example(InvoiceEnterpriseDayStatisticEffect.class);
        Example.Criteria dayMiddleCriteria = dayExample.createCriteria();
        dayMiddleCriteria.andBetween("regDate", (Object)regStartDate, (Object)regEndDate);
        this.dayStatisticEffectMapper.deleteByExample(dayExample);
    }

    private void deleteInvoiceEnterDay(LocalDate startDate, LocalDate endDate) {
        Example dayExample = new Example(InvoiceEnterpriseDayStatistic.class);
        Example.Criteria dayMiddleCriteria = dayExample.createCriteria();
        dayMiddleCriteria.andBetween("day", (Object)startDate, (Object)endDate);
        this.dayStatisticMapper.deleteByExample(dayExample);
    }

    private void deleteInvoiceEnterWeek(Integer startWeekCode, Integer endWeekCode) {
        Example weekExample = new Example(InvoiceEnterpriseWeekStatistic.class);
        Example.Criteria weekCriteria = weekExample.createCriteria();
        weekCriteria.andBetween("weekCode", (Object)startWeekCode, (Object)endWeekCode);
        this.weekStatisticMapper.deleteByExample(weekExample);
    }

    private void deleteInvoiceEnterMonth(Integer startMonthCode, Integer endMonthCode) {
        Example monthExample = new Example(InvoiceEnterpriseMonthStatistic.class);
        Example.Criteria monthCriteria = monthExample.createCriteria();
        monthCriteria.andBetween("monthCode", (Object)startMonthCode, (Object)endMonthCode);
        this.monthStatisticMapper.deleteByExample(monthExample);
    }

    @Bean(value={"invoiceEnterDayEffectJob"})
    public Job invoiceEnterDayEffectJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterDayEffectJob").start(this.invoiceEnterDayEffectStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterDayEffectStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("invoiceEnterDayEffectStep").tasklet((stepContribution, chunkContext) -> {
            List<InvoiceEnterpriseDayTranstionStatistic> dayTranstionStatistics = this.dayTranstionStatisticMapper.statisticDayEffect();
            ArrayList<InvoiceEnterpriseDayStatisticEffect> dayStatisticEffects = new ArrayList<InvoiceEnterpriseDayStatisticEffect>();
            for (InvoiceEnterpriseDayTranstionStatistic dayTranstionStatistic : dayTranstionStatistics) {
                InvoiceEnterpriseDayStatisticEffect dayStatisticEffect = new InvoiceEnterpriseDayStatisticEffect();
                BeanUtils.copyProperties((Object)dayTranstionStatistic, (Object)dayStatisticEffect);
                dayStatisticEffects.add(dayStatisticEffect);
            }
            if (dayStatisticEffects.size() > 0) {
                this.dayStatisticEffectMapper.batchSaveOrUpdate(dayStatisticEffects);
            }
            return RepeatStatus.FINISHED;
        }).allowStartIfComplete(true)).build();
    }

    @Bean(value={"invoiceEnterDayJob"})
    public Job invoiceEnterDayJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterDayJob").start(this.invoiceEnterDayStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterDayStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("invoiceEnterDayStep").tasklet((stepContribution, chunkContext) -> {
            Map map = chunkContext.getStepContext().getJobParameters();
            if (map.get("startDate") != null && map.get("endDate") != null) {
                LocalDate startDate = LocalDate.parse(map.get("startDate").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                LocalDate endDate = LocalDate.parse(map.get("endDate").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                List<InvoiceEnterpriseDayStatisticEffect> dayStatisticEffects = this.dayStatisticEffectMapper.statisticDay(startDate, endDate);
                ArrayList<InvoiceEnterpriseDayStatistic> dayStatistics = new ArrayList<InvoiceEnterpriseDayStatistic>();
                for (InvoiceEnterpriseDayStatisticEffect dayStatisticEffect : dayStatisticEffects) {
                    InvoiceEnterpriseDayStatistic dayStatistic = new InvoiceEnterpriseDayStatistic();
                    BeanUtils.copyProperties((Object)dayStatisticEffect, (Object)dayStatistic);
                    dayStatistics.add(dayStatistic);
                }
                if (dayStatistics.size() > 0) {
                    this.dayStatisticMapper.batchSaveOrUpdate(dayStatistics);
                }
            }
            return RepeatStatus.FINISHED;
        }).allowStartIfComplete(true)).build();
    }

    @Bean(value={"invoiceEnterDayVerifyJob"})
    public Job invoiceEnterDayVerifyJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterDayVerifyJob").start(this.invoiceEnterDayVerifyStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterDayVerifyStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("invoiceEnterDayVerifyStep").tasklet((stepContribution, chunkContext) -> {
            Map map = chunkContext.getStepContext().getJobParameters();
            String startDateStr = (String)map.get("startDate");
            String endDateStr = (String)map.get("endDate");
            if (StringUtils.isNotBlank((CharSequence)startDateStr) && StringUtils.isNotBlank((CharSequence)endDateStr)) {
                LocalDate startDate = LocalDate.parse(startDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                LocalDate endDate = LocalDate.parse(endDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                List<InvoiceEnterpriseDayStatistic> dayStatistics = this.dayStatisticHandler.selectEnterDayList(startDate, endDate);
                List<InvoiceEnterpriseDayStatisticMiddle> dayStatisticMiddles = this.dayStatisticMiddleHandler.selectEnterDayMiddleList(startDate, endDate);
                Map<Object, Object> dayStatisticMap = null;
                dayStatisticMap = dayStatistics != null && dayStatistics.size() > 0 ? dayStatistics.stream().collect(Collectors.toMap(o -> o.getDay().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + o.getEnterpriseCode() + o.getBizSubjectCode() + o.getInvoiceNature(), day -> day)) : new HashMap();
                Map<Object, Object> dayStatisticMiddleMap = null;
                dayStatisticMiddleMap = dayStatisticMiddles != null && dayStatisticMiddles.size() > 0 ? dayStatisticMiddles.stream().collect(Collectors.toMap(o -> o.getDay().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + o.getEnterpriseCode() + o.getBizSubjectCode() + o.getInvoiceNature(), day -> day)) : new HashMap();
                Set<Object> keySet = dayStatisticMap.keySet();
                Iterator<Object> iterator = keySet.iterator();
                ArrayList<Object> verifyList = new ArrayList<InvoiceEnterpriseDayStatisticVerify>();
                ArrayList<Object> dayStatisticMiddleList = new ArrayList<InvoiceEnterpriseDayStatisticMiddle>();
                int i = 0;
                while (iterator.hasNext()) {
                    ++i;
                    String key = (String)iterator.next();
                    InvoiceEnterpriseDayStatistic dayStatistic = (InvoiceEnterpriseDayStatistic)dayStatisticMap.get(key);
                    InvoiceEnterpriseDayStatisticMiddle dayStatisticMiddle = null;
                    if (dayStatisticMiddleMap != null && dayStatisticMiddleMap.size() > 0) {
                        dayStatisticMiddle = (InvoiceEnterpriseDayStatisticMiddle)dayStatisticMiddleMap.get(key);
                    }
                    if (dayStatisticMiddle == null) {
                        dayStatisticMiddle = new InvoiceEnterpriseDayStatisticMiddle();
                        BeanUtils.copyProperties((Object)dayStatistic, (Object)dayStatisticMiddle);
                    }
                    InvoiceEnterpriseDayStatisticVerify dayStatisticVerify = this.dayStatisticHandler.dayStatisticVerify(dayStatistic, dayStatisticMiddle);
                    verifyList.add(dayStatisticVerify);
                    dayStatisticMiddleList.add(dayStatisticMiddle);
                    if (i != 500) continue;
                    i = 0;
                    this.dayStatisticVerifyMapper.batchSaveUpdate(verifyList);
                    this.dayStatisticMiddleMapper.batchSaveOrUpdate(dayStatisticMiddleList);
                    verifyList = new ArrayList();
                    dayStatisticMiddleList = new ArrayList();
                }
                if (verifyList.size() > 0) {
                    this.dayStatisticVerifyMapper.batchSaveUpdate(verifyList);
                }
                if (dayStatisticMiddleList.size() > 0) {
                    this.dayStatisticMiddleMapper.batchSaveOrUpdate(dayStatisticMiddleList);
                }
            }
            return RepeatStatus.FINISHED;
        }).allowStartIfComplete(true)).build();
    }

    @Bean(value={"invoiceEnterWeekJob"})
    public Job invoiceEnterWeekJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterWeekJob").start(this.invoiceEnterWeekStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterWeekStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("invoiceEnterWeekStep").tasklet((stepContribution, chunkContext) -> {
            Map map = chunkContext.getStepContext().getJobParameters();
            if (map.get("startDate") != null && map.get("endDate") != null) {
                LocalDate startDate = LocalDate.parse(map.get("startDate").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                LocalDate endDate = LocalDate.parse(map.get("endDate").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                Integer startWeekCode = this.dayStatisticMiddleHandler.getWeekCode(startDate);
                Integer endWeekCode = this.dayStatisticMiddleHandler.getWeekCode(endDate);
                List<InvoiceEnterpriseDayStatisticEffect> invoiceEnterpriseDayStatisticEffects = this.dayStatisticEffectMapper.statisticWeek(startWeekCode, endWeekCode);
                ArrayList<InvoiceEnterpriseWeekStatistic> weekStatistics = new ArrayList<InvoiceEnterpriseWeekStatistic>();
                for (InvoiceEnterpriseDayStatisticEffect invoiceEnterpriseDayStatisticEffect : invoiceEnterpriseDayStatisticEffects) {
                    InvoiceEnterpriseWeekStatistic weekStatistic = new InvoiceEnterpriseWeekStatistic();
                    BeanUtils.copyProperties((Object)invoiceEnterpriseDayStatisticEffect, (Object)weekStatistic);
                    weekStatistic.setStatisticDay(LocalDate.now());
                    weekStatistic.setStatisticTime(LocalDateTime.now());
                    LocalDate statisticEndDate = invoiceEnterpriseDayStatisticEffect.getWeekEndDate();
                    LocalDate[] weekStartEndDate = this.dayStatisticMiddleHandler.getWeekStartEndDate(statisticEndDate);
                    weekStatistic.setWeekStartDate(weekStartEndDate[0]);
                    weekStatistic.setWeekEndDate(weekStartEndDate[1]);
                    weekStatistic.setEndDate(statisticEndDate);
                    weekStatistic.setWeek(Integer.valueOf(statisticEndDate.get(ChronoField.ALIGNED_WEEK_OF_MONTH)));
                    weekStatistics.add(weekStatistic);
                }
                if (weekStatistics.size() > 0) {
                    this.weekStatisticMapper.batchSaveOrUpdate(weekStatistics);
                }
            }
            return RepeatStatus.FINISHED;
        }).allowStartIfComplete(true)).build();
    }

    @Bean(value={"invoiceEnterWeekVerifyJob"})
    public Job invoiceEnterWeekVerifyJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterWeekVerifyJob").start(this.invoiceEnterWeekVerifyStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterWeekVerifyStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("invoiceEnterWeekVerifyStep").tasklet((stepContribution, chunkContext) -> {
            Map map = chunkContext.getStepContext().getJobParameters();
            String startDateStr = (String)map.get("startDate");
            String endDateStr = (String)map.get("endDate");
            if (StringUtils.isNotBlank((CharSequence)startDateStr) && StringUtils.isNotBlank((CharSequence)endDateStr)) {
                LocalDate startDate = LocalDate.parse(startDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                LocalDate endDate = LocalDate.parse(endDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                Integer startWeekCode = this.dayStatisticMiddleHandler.getWeekCode(startDate);
                Integer endWeekCode = this.dayStatisticMiddleHandler.getWeekCode(endDate);
                List<InvoiceEnterpriseWeekStatistic> weekStatistics = this.dayStatisticHandler.selectEnterWeekList(startWeekCode, endWeekCode);
                List<InvoiceEnterpriseWeekStatisticMiddle> weekStatisticMiddles = this.dayStatisticMiddleHandler.selectEnterWeekMiddleList(startWeekCode, endWeekCode);
                Map<Object, Object> weekStatisticMap = null;
                weekStatisticMap = weekStatistics != null ? weekStatistics.stream().collect(Collectors.toMap(o -> o.getWeekCode() + o.getEnterpriseCode() + o.getBizSubjectCode() + o.getInvoiceNature(), week -> week)) : new HashMap();
                Map<Object, Object> weekStatisticMiddleMap = null;
                weekStatisticMiddleMap = weekStatisticMiddles != null ? weekStatisticMiddles.stream().collect(Collectors.toMap(o -> o.getWeekCode() + o.getEnterpriseCode() + o.getBizSubjectCode() + o.getInvoiceNature(), week -> week)) : new HashMap();
                Set<Object> keySet = weekStatisticMap.keySet();
                for (String string : keySet) {
                    InvoiceEnterpriseWeekStatistic weekStatistic = (InvoiceEnterpriseWeekStatistic)weekStatisticMap.get(string);
                    InvoiceEnterpriseWeekStatisticMiddle weekStatisticMiddle = null;
                    if (weekStatisticMiddleMap != null && weekStatisticMiddleMap.size() > 0) {
                        weekStatisticMiddle = (InvoiceEnterpriseWeekStatisticMiddle)weekStatisticMiddleMap.get(string);
                    }
                    if (weekStatisticMiddle == null) {
                        weekStatisticMiddle = new InvoiceEnterpriseWeekStatisticMiddle();
                        BeanUtils.copyProperties((Object)weekStatistic, (Object)weekStatisticMiddle);
                    }
                    this.dayStatisticHandler.weekStatisticVerify(weekStatistic, weekStatisticMiddle);
                }
            }
            return RepeatStatus.FINISHED;
        }).allowStartIfComplete(true)).build();
    }

    @Bean(value={"invoiceEnterAccumulateJob"})
    public Job invoiceEnterAccumulateJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterAccumulateJob").start(this.invoiceEnterAccumulateStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterAccumulateStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("invoiceEnterAccumulateStep").tasklet((stepContribution, chunkContext) -> {
            Map map = chunkContext.getStepContext().getJobParameters();
            if (map.get("regStartDate") != null && map.get("regEndDate") != null) {
                LocalDate regStartDate = LocalDate.parse(map.get("regStartDate").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                LocalDate regEndDate = LocalDate.parse(map.get("regEndDate").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                long intervalDay = regEndDate.toEpochDay() - regStartDate.toEpochDay();
                for (long i = 0L; i <= intervalDay; ++i) {
                    LocalDate regDate = regStartDate.plusDays(i);
                    this.accumulateStatisticMapper.insertIntoSelectByEffect(regDate);
                }
                List<InvoiceEnterpriseAccumulateStatistic> invoiceEnterpriseAccumulateStatistics = this.accumulateStatisticMapper.selectByEndDate(regStartDate, regEndDate);
                ArrayList<InvoiceEnterpriseAccumulateStatisticMiddle> accumulateStatisticMiddles = new ArrayList<InvoiceEnterpriseAccumulateStatisticMiddle>();
                for (InvoiceEnterpriseAccumulateStatistic invoiceEnterpriseAccumulateStatistic : invoiceEnterpriseAccumulateStatistics) {
                    InvoiceEnterpriseAccumulateStatisticMiddle middle = new InvoiceEnterpriseAccumulateStatisticMiddle();
                    BeanUtils.copyProperties((Object)invoiceEnterpriseAccumulateStatistic, (Object)middle);
                    middle.setEnterpriseNamePinyin(PingYinUtil.getPingYin(invoiceEnterpriseAccumulateStatistic.getEnterpriseName()));
                    accumulateStatisticMiddles.add(middle);
                }
                if (accumulateStatisticMiddles.size() > 0) {
                    this.accumulateStatisticMiddleMapper.batchSaveOrUpdate(accumulateStatisticMiddles);
                }
            }
            return RepeatStatus.FINISHED;
        }).allowStartIfComplete(true)).build();
    }

    @Bean(value={"invoiceEnterMonthJob"})
    public Job invoiceEnterMonthJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterMonthJob").start(this.invoiceEnterMonthStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterMonthStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("invoiceEnterMonthStep").tasklet((stepContribution, chunkContext) -> {
            Map map = chunkContext.getStepContext().getJobParameters();
            if (map.get("startDate") != null && map.get("endDate") != null) {
                LocalDate startDate = LocalDate.parse(map.get("startDate").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                LocalDate endDate = LocalDate.parse(map.get("endDate").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                Integer startMonthCode = this.dayStatisticMiddleHandler.getMonthCode(startDate);
                Integer endMonthCode = this.dayStatisticMiddleHandler.getMonthCode(endDate);
                List<InvoiceEnterpriseDayStatisticEffect> invoiceEnterpriseDayStatisticEffects = this.dayStatisticEffectMapper.statisticMonth(startMonthCode, endMonthCode);
                ArrayList<InvoiceEnterpriseMonthStatistic> monthStatistics = new ArrayList<InvoiceEnterpriseMonthStatistic>();
                for (InvoiceEnterpriseDayStatisticEffect invoiceEnterpriseDayStatisticEffect : invoiceEnterpriseDayStatisticEffects) {
                    InvoiceEnterpriseMonthStatistic monthStatistic = new InvoiceEnterpriseMonthStatistic();
                    BeanUtils.copyProperties((Object)invoiceEnterpriseDayStatisticEffect, (Object)monthStatistic);
                    monthStatistic.setStatisticDay(LocalDate.now());
                    monthStatistic.setStatisticTime(LocalDateTime.now());
                    LocalDate statisticEndDate = invoiceEnterpriseDayStatisticEffect.getMonthEndDate();
                    LocalDate[] monthStartEndDate = this.dayStatisticMiddleHandler.getMonthStartEndDate(statisticEndDate);
                    monthStatistic.setMonthStartDate(monthStartEndDate[0]);
                    monthStatistic.setMonthEndDate(monthStartEndDate[1]);
                    monthStatistic.setEndDate(statisticEndDate);
                    monthStatistics.add(monthStatistic);
                }
                if (monthStatistics.size() > 0) {
                    this.monthStatisticMapper.batchSaveOrUpdate(monthStatistics);
                }
            }
            return RepeatStatus.FINISHED;
        }).allowStartIfComplete(true)).build();
    }

    @Bean(value={"invoiceEnterMonthVerifyJob"})
    public Job invoiceEnterMonthVerifyJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterMonthVerifyJob").start(this.invoiceEnterMonthVerifyStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterMonthVerifyStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("invoiceEnterMonthVerifyStep").tasklet((stepContribution, chunkContext) -> {
            Map map = chunkContext.getStepContext().getJobParameters();
            String startDateStr = (String)map.get("startDate");
            String endDateStr = (String)map.get("endDate");
            if (StringUtils.isNotBlank((CharSequence)startDateStr) && StringUtils.isNotBlank((CharSequence)endDateStr)) {
                LocalDate startDate = LocalDate.parse(startDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                LocalDate endDate = LocalDate.parse(endDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                Integer startMonthCode = this.dayStatisticMiddleHandler.getMonthCode(startDate);
                Integer endMonthCode = this.dayStatisticMiddleHandler.getMonthCode(endDate);
                List<InvoiceEnterpriseMonthStatistic> monthStatistics = this.dayStatisticHandler.selectEnterMonthList(startMonthCode, endMonthCode);
                List<InvoiceEnterpriseMonthStatisticMiddle> monthStatisticMiddles = this.dayStatisticMiddleHandler.selectEnterMonthMiddleList(startMonthCode, endMonthCode);
                Map<Object, Object> monthStatisticMap = null;
                monthStatisticMap = monthStatistics != null ? monthStatistics.stream().collect(Collectors.toMap(o -> o.getMonthCode() + o.getEnterpriseCode() + o.getBizSubjectCode() + o.getInvoiceNature(), week -> week)) : new HashMap();
                Map<Object, Object> monthStatisticMiddleMap = null;
                monthStatisticMiddleMap = monthStatisticMiddles != null ? monthStatisticMiddles.stream().collect(Collectors.toMap(o -> o.getMonthCode() + o.getEnterpriseCode() + o.getBizSubjectCode() + o.getInvoiceNature(), week -> week)) : new HashMap();
                Set<Object> keySet = monthStatisticMap.keySet();
                for (String string : keySet) {
                    InvoiceEnterpriseMonthStatistic monthStatistic = (InvoiceEnterpriseMonthStatistic)monthStatisticMap.get(string);
                    InvoiceEnterpriseMonthStatisticMiddle monthStatisticMiddle = null;
                    if (monthStatisticMiddleMap != null && monthStatisticMiddleMap.size() > 0) {
                        monthStatisticMiddle = (InvoiceEnterpriseMonthStatisticMiddle)monthStatisticMiddleMap.get(string);
                    }
                    if (monthStatisticMiddle == null) {
                        monthStatisticMiddle = new InvoiceEnterpriseMonthStatisticMiddle();
                        BeanUtils.copyProperties((Object)monthStatistic, (Object)monthStatisticMiddle);
                    }
                    this.dayStatisticHandler.monthStatisticVerify(monthStatistic, monthStatisticMiddle);
                }
            }
            return RepeatStatus.FINISHED;
        }).allowStartIfComplete(true)).build();
    }

    @Bean(value={"invoiceEnterTranstionJob"})
    public Job invoiceEnterTranstionJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterTranstionJob").start(this.invoiceEnterTranstionStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterTranstionStep() {
        return this.stepBuilderFactory.get("invoiceEnterTranstionStep").chunk(1000).reader(this.invoiceEventEnterItemReader).writer(this.transtionDayItemWriter).taskExecutor((TaskExecutor)this.batchTaskExecutor).throttleLimit(2).build();
    }

    @Bean(value={"invoiceEnterDayItemReader"})
    @StepScope
    public synchronized ItemReader<InvoiceEnterpriseDayStatistic> invoiceEnterDayItemReader(@Value(value="#{jobParameters[startDate]}") String startDate, @Value(value="#{jobParameters[endDate]}") String endDate) {
        JdbcPagingItemReader reader = new JdbcPagingItemReader();
        reader.setDataSource(this.dataSource);
        reader.setPageSize(500);
        reader.setRowMapper((RowMapper)new InvoiceEnterpriseDayStatisticItemRowMapper());
        MySqlPagingQueryProvider queryProvider = new MySqlPagingQueryProvider();
        queryProvider.setSelectClause("*");
        queryProvider.setFromClause("invoice_enterprise_day_statistic");
        queryProvider.setWhereClause(" day between :startDate and :endDate");
        HashMap<String, Order> sortKeys = new HashMap<String, Order>(1);
        sortKeys.put("id", Order.ASCENDING);
        queryProvider.setSortKeys(sortKeys);
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        reader.setParameterValues(params);
        reader.setQueryProvider((PagingQueryProvider)queryProvider);
        return reader;
    }

    @Bean(value={"invoiceEventEnterItemReader"})
    @StepScope
    public synchronized ItemReader<InvoiceEnterpriseOperateDetail> invoiceEventEnterItemReader(@Value(value="#{jobParameters[regStartDate]}") String regStartDate, @Value(value="#{jobParameters[regEndDate]}") String regEndDate, @Value(value="#{jobParameters[endTime]}") String endTime) {
        JdbcPagingItemReader reader = new JdbcPagingItemReader();
        reader.setDataSource(this.dataSource);
        reader.setPageSize(500);
        reader.setRowMapper((RowMapper)new InvoiceOperateDetailItemRowMapper());
        MySqlPagingQueryProvider queryProvider = new MySqlPagingQueryProvider();
        queryProvider.setSelectClause("*");
        queryProvider.setFromClause("invoice_enterprise_operate_detail");
        queryProvider.setWhereClause(" reg_date between :regStartDate and :regEndDate and operate_time <=:endTime");
        HashMap<String, Order> sortKeys = new HashMap<String, Order>(1);
        sortKeys.put("id", Order.ASCENDING);
        queryProvider.setSortKeys(sortKeys);
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("regStartDate", regStartDate);
        params.put("regEndDate", regEndDate);
        params.put("endTime", endTime);
        reader.setParameterValues(params);
        reader.setQueryProvider((PagingQueryProvider)queryProvider);
        return reader;
    }

    public void getDefault(LocalDate startDate, LocalDate endDate, String key) throws Exception {
        InvoiceJobReq invoiceJobReq = (InvoiceJobReq)this.objectMapper.readValue((String)this.redisTemplate.opsForValue().get((Object)key), InvoiceJobReq.class);
        List enterpriseBasePoints = invoiceJobReq.getBasePointList();
        List bizSubjects = invoiceJobReq.getBizSubjects();
        Long dayCnt = endDate.toEpochDay() - startDate.toEpochDay();
        Long i = 0L;
        while (i <= dayCnt) {
            ArrayList<InvoiceEnterpriseDayTranstionStatistic> dayTranstionStatistics = new ArrayList<InvoiceEnterpriseDayTranstionStatistic>();
            LocalDate day = startDate.plusDays(i);
            for (BizSubject bizSubject : bizSubjects) {
                for (EnterpriseBasePoint enterpriseBasePoint : enterpriseBasePoints) {
                    InvoiceEnterpriseDayTranstionStatistic enterpriseDayTranstionStatistic = new InvoiceEnterpriseDayTranstionStatistic();
                    enterpriseDayTranstionStatistic.setStatisticDay(LocalDate.now());
                    if (bizSubject.getBizSubjectCode().equals(this.bizSubjectConfig.getGzcode())) {
                        enterpriseDayTranstionStatistic.setInvoiceNature(InvoiceNatureEnum.GZROCO_BASE_POINT);
                    } else if (bizSubject.getBizSubjectCode().equals(this.bizSubjectConfig.getBjcode())) {
                        enterpriseDayTranstionStatistic.setInvoiceNature(InvoiceNatureEnum.BJROCO_BASE_POINT);
                    }
                    enterpriseDayTranstionStatistic.setEnterpriseCode(enterpriseBasePoint.getEnterpriseCode());
                    enterpriseDayTranstionStatistic.setEnterpriseName(enterpriseBasePoint.getEnterpriseName());
                    enterpriseDayTranstionStatistic.setBizSubjectCode(bizSubject.getBizSubjectCode());
                    enterpriseDayTranstionStatistic.setBizSubjectName(bizSubject.getBizSubjectName());
                    enterpriseDayTranstionStatistic.setMonthCode(this.dayStatisticMiddleHandler.getMonthCode(day));
                    enterpriseDayTranstionStatistic.setMonth(Integer.valueOf(day.getMonthValue()));
                    enterpriseDayTranstionStatistic.setRegDate(day);
                    enterpriseDayTranstionStatistic.setStatisticTime(LocalDateTime.now());
                    enterpriseDayTranstionStatistic.setWeekCode(this.dayStatisticMiddleHandler.getWeekCode(day));
                    enterpriseDayTranstionStatistic.setYear(Integer.valueOf(day.getYear()));
                    enterpriseDayTranstionStatistic.setArrivalAmount(BigDecimal.ZERO);
                    enterpriseDayTranstionStatistic.setArrivalCnt(Long.valueOf(0L));
                    enterpriseDayTranstionStatistic.setInvalidAmount(BigDecimal.ZERO);
                    enterpriseDayTranstionStatistic.setInvalidCnt(Long.valueOf(0L));
                    enterpriseDayTranstionStatistic.setTotalAmount(BigDecimal.ZERO);
                    enterpriseDayTranstionStatistic.setTotalCnt(Long.valueOf(0L));
                    enterpriseDayTranstionStatistic.setDay(day);
                    dayTranstionStatistics.add(enterpriseDayTranstionStatistic);
                }
            }
            this.dayTranstionStatisticMapper.batchSaveOrUpdate(dayTranstionStatistics);
            Long l = i;
            Long l2 = i = Long.valueOf(i + 1L);
        }
    }

    @Bean(value={"transtionDayItemWriter"})
    @StepScope
    public ItemWriter<InvoiceEnterpriseOperateDetail> transtionDayItemWriter() {
        try {
            ItemWriter<InvoiceEnterpriseOperateDetail> itemWriter = new ItemWriter<InvoiceEnterpriseOperateDetail>(){

                public void write(List<? extends InvoiceEnterpriseOperateDetail> list) throws Exception {
                    log.info("\u5f00\u59cb\u5904\u7406\u6bcf\u9875\u6570\u636e\u5927\u5c0f\uff1a{}", (Object)list.size());
                    List<InvoiceEnterpriseDayStatisticDTO> dtos = InvoiceEnterpriseStatisticJobConfig.this.dayStatisticMiddleHandler.getDayStatistic(list);
                    ArrayList<InvoiceEnterpriseDayTranstionStatistic> dayStatistics = new ArrayList<InvoiceEnterpriseDayTranstionStatistic>();
                    for (InvoiceEnterpriseDayStatisticDTO dto : dtos) {
                        InvoiceEnterpriseDayTranstionStatistic dayTranstionStatistic = new InvoiceEnterpriseDayTranstionStatistic();
                        BeanUtils.copyProperties((Object)dto, (Object)dayTranstionStatistic);
                        LocalDate day = dto.getDay();
                        dayTranstionStatistic.setYear(Integer.valueOf(day.getYear()));
                        dayTranstionStatistic.setMonth(Integer.valueOf(day.getMonthValue()));
                        dayTranstionStatistic.setWeekCode(InvoiceEnterpriseStatisticJobConfig.this.dayStatisticMiddleHandler.getWeekCode(day));
                        dayTranstionStatistic.setStatisticDay(LocalDate.now());
                        dayTranstionStatistic.setStatisticTime(LocalDateTime.now());
                        dayTranstionStatistic.setRegDate(dto.getRegDate());
                        dayTranstionStatistic.setMonthCode(InvoiceEnterpriseStatisticJobConfig.this.dayStatisticMiddleHandler.getMonthCode(day));
                        dayStatistics.add(dayTranstionStatistic);
                    }
                    InvoiceEnterpriseStatisticJobConfig.this.dayTranstionStatisticMapper.batchSaveOrUpdate(dayStatistics);
                }
            };
            return itemWriter;
        }
        catch (Exception e) {
            log.error("\u53d1\u7968\u65e5\u95f4\u7edf\u8ba1\u6279\u5904\u7406\u8fc7\u6e21\u6570\u636e\u5165\u5e93\u5931\u8d25:{}", (Throwable)e);
            return null;
        }
    }

    protected class InvoiceOperateDetailItemRowMapper
    implements RowMapper<InvoiceEnterpriseOperateDetail> {
        protected InvoiceOperateDetailItemRowMapper() {
        }

        public InvoiceEnterpriseOperateDetail mapRow(ResultSet resultSet, int i) throws SQLException {
            InvoiceEnterpriseOperateDetail operateDetail = new InvoiceEnterpriseOperateDetail();
            operateDetail.setId(Long.valueOf(resultSet.getLong("id")));
            operateDetail.setInvoiceNature(InvoiceNatureEnum.valueOf((String)resultSet.getString("invoice_nature")));
            operateDetail.setInvoiceAmount(resultSet.getBigDecimal("invoice_amount"));
            operateDetail.setOperation(InvoiceOperateEnum.valueOf((String)resultSet.getString("operation")));
            operateDetail.setRegDate(resultSet.getDate("reg_date").toLocalDate());
            operateDetail.setEnterpriseCode(resultSet.getString("enterprise_code"));
            operateDetail.setEnterpriseName(resultSet.getString("enterprise_name"));
            operateDetail.setBizSubjectCode(resultSet.getString("biz_subject_code"));
            operateDetail.setBizSubjectName(resultSet.getString("biz_subject_name"));
            operateDetail.setDay(resultSet.getDate("day").toLocalDate());
            return operateDetail;
        }
    }

    protected class InvoiceEnterpriseDayStatisticItemRowMapper
    implements RowMapper<InvoiceEnterpriseDayStatistic> {
        protected InvoiceEnterpriseDayStatisticItemRowMapper() {
        }

        public InvoiceEnterpriseDayStatistic mapRow(ResultSet rs, int i) throws SQLException {
            InvoiceEnterpriseDayStatistic invoiceEnterpriseDayStatistic = new InvoiceEnterpriseDayStatistic();
            invoiceEnterpriseDayStatistic.setYear(Integer.valueOf(rs.getInt("year")));
            invoiceEnterpriseDayStatistic.setMonth(Integer.valueOf(rs.getInt("month")));
            invoiceEnterpriseDayStatistic.setDay(rs.getDate("day").toLocalDate());
            invoiceEnterpriseDayStatistic.setWeekCode(Integer.valueOf(rs.getInt("week_code")));
            invoiceEnterpriseDayStatistic.setEnterpriseCode(rs.getString("enterprise_code"));
            invoiceEnterpriseDayStatistic.setEnterpriseName(rs.getString("enterprise_name"));
            invoiceEnterpriseDayStatistic.setBizSubjectCode(rs.getString("biz_subject_code"));
            invoiceEnterpriseDayStatistic.setBizSubjectName(rs.getString("biz_subject_name"));
            invoiceEnterpriseDayStatistic.setTotalCnt(Long.valueOf(rs.getLong("total_cnt")));
            invoiceEnterpriseDayStatistic.setTotalAmount(rs.getBigDecimal("total_amount"));
            invoiceEnterpriseDayStatistic.setInvalidCnt(Long.valueOf(rs.getLong("invalid_cnt")));
            invoiceEnterpriseDayStatistic.setInvalidAmount(rs.getBigDecimal("invalid_amount"));
            invoiceEnterpriseDayStatistic.setArrivalCnt(Long.valueOf(rs.getLong("arrival_cnt")));
            invoiceEnterpriseDayStatistic.setInvoiceNature(InvoiceNatureEnum.valueOf((String)rs.getString("invoice_nature")));
            invoiceEnterpriseDayStatistic.setStatisticDay(rs.getDate("statistic_day").toLocalDate());
            invoiceEnterpriseDayStatistic.setStatisticTime(rs.getTimestamp("statistic_time").toLocalDateTime());
            return invoiceEnterpriseDayStatistic;
        }
    }
}

