/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.schedule;

import com.rocogz.common.api.request.CommonRequest;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEvent;
import com.rocoinfo.oilcard.batch.api.request.invoice.InvoiceJobReq;
import com.rocoinfo.oilcard.batch.base.lock.RedisDistributedLock;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEventDao;
import com.rocoinfo.oilcard.batch.dto.InvoiceStatisticsMqPushReq;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceJobStatisticStartHandler;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceStatisticConsumerHandler;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class InvoiceJobSchedule {
    private static final Logger log = LoggerFactory.getLogger(InvoiceJobSchedule.class);
    @Autowired
    private InvoiceJobStatisticStartHandler invoiceJobStatisticStartHandler;
    @Autowired
    private InvoiceEventDao invoiceEventDao;
    @Autowired
    private InvoiceStatisticConsumerHandler invoiceStatisticConsumerHandler;
    @Autowired
    private RedisDistributedLock redisDistributedLock;

    @Scheduled(cron="0 5 0 * * ?")
    public void invoiceStatistic() {
        log.info("invoiceStatistic \u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb=====");
        CommonRequest request = new CommonRequest();
        InvoiceJobReq invoiceJobReq = new InvoiceJobReq();
        String currentDay = LocalDate.now().plusDays(-1L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        Map<String, Object> map = this.invoiceEventDao.selectConfirmInvoiceDate(currentDay + " 00:00:00", currentDay + " 23:59:59");
        String maxConfirmInvoiceDate = null;
        String minConfirmInvoiceDate = null;
        if (map != null && map.size() > 0) {
            maxConfirmInvoiceDate = map.get("max_confirm_invoice_date").toString();
            minConfirmInvoiceDate = map.get("min_confirm_invoice_date").toString();
        } else {
            maxConfirmInvoiceDate = currentDay;
            minConfirmInvoiceDate = currentDay;
        }
        invoiceJobReq.setStartDate(LocalDate.parse(minConfirmInvoiceDate, DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        invoiceJobReq.setEndDate(LocalDate.parse(maxConfirmInvoiceDate, DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        request.setRequest((Object)invoiceJobReq);
        this.invoiceJobStatisticStartHandler.call(request);
        log.info("invoiceStatistic \u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f=====");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 0/30 * * * ?")
    public void invoiceFailHandleStatistic() {
        String lockKey = "invoiceFailHandleStatistic";
        try {
            boolean flag = this.redisDistributedLock.lock(lockKey, 1800L, 5, 2000L);
            if (flag) {
                log.info("invoiceFailHandleStatistic \u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb=====");
                List<InvoiceEvent> invoiceEvents = this.invoiceEventDao.selectByFail(LocalDateTime.now());
                for (InvoiceEvent invoiceEvent : invoiceEvents) {
                    if (invoiceEvent.getOperation() == null) continue;
                    InvoiceStatisticsMqPushReq pushReq = new InvoiceStatisticsMqPushReq();
                    BeanUtils.copyProperties((Object)invoiceEvent, (Object)pushReq);
                    this.invoiceStatisticConsumerHandler.invoiceActualStatistic(invoiceEvent, pushReq);
                }
                log.info("invoiceFailHandleStatistic \u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f=====");
            }
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u4e3b\u4f53\u53d1\u7968\u5931\u8d25\u5904\u7406\u5f02\u5e38:{}", (Throwable)e);
        }
        finally {
            this.redisDistributedLock.releaseLock(lockKey);
        }
    }
}

