/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.base.lock;

import com.rocoinfo.oilcard.batch.base.lock.AbstractDistributedLock;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisDistributedLock
extends AbstractDistributedLock {
    private static final Logger log = LoggerFactory.getLogger(RedisDistributedLock.class);
    private StringRedisTemplate redisTemplate;
    private ThreadLocal<String> lockFlag = new ThreadLocal();

    public RedisDistributedLock(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public boolean lock(String key, long expire, int retryTimes, long sleepMillis) {
        boolean result = this.setRedis(key, expire);
        while (!Thread.currentThread().isInterrupted() && !result && retryTimes-- > 0) {
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("get lock occured an exception,", (Throwable)e);
                return false;
            }
            result = this.setRedis(key, expire);
            log.debug("retry get [{}] lock: {} ,remaining times: {}", new Object[]{key, result, retryTimes});
        }
        return result;
    }

    public boolean releaseLock(String key) {
        boolean result = false;
        try {
            if (this.lockFlag.get() != null && ((String)this.lockFlag.get()).equals(this.redisTemplate.opsForValue().get((Object)key))) {
                this.redisTemplate.delete((Object)key);
                this.lockFlag.remove();
                log.debug("release [{}] lock", (Object)key);
            }
            result = true;
        }
        catch (Exception e) {
            log.error("release lock occured an exception", (Throwable)e);
        }
        return result;
    }

    private boolean setRedis(String key, long expire) {
        boolean result = false;
        try {
            this.lockFlag.set(UUID.randomUUID().toString());
            result = this.redisTemplate.opsForValue().setIfAbsent((Object)key, this.lockFlag.get(), expire, TimeUnit.MILLISECONDS);
            if (result) {
                log.debug("lock [{}] expire: {}ms", (Object)key, (Object)expire);
            }
        }
        catch (Exception e) {
            log.error("set redis occured an exception", (Throwable)e);
        }
        log.debug("get [{}] lock: {}", (Object)key, (Object)result);
        return result;
    }
}

