/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.consumer;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Charsets;
import com.rabbitmq.client.Channel;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEvent;
import com.rocoinfo.oilcard.batch.api.enums.MqCustomerStatus;
import com.rocoinfo.oilcard.batch.dto.InvoiceStatisticsMqPushReq;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceEventHandler;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceStatisticConsumerHandler;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceStatisticHandler;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InvoiceStatisticsConsumer {
    private static final Logger log = LoggerFactory.getLogger(InvoiceStatisticsConsumer.class);
    @Autowired
    private InvoiceEventHandler invoiceEventService;
    @Autowired
    private InvoiceStatisticHandler invoiceStatisticsService;
    @Autowired
    private InvoiceStatisticConsumerHandler statisticConsumerHandler;

    @RabbitListener(queues={"invoice_statistics_queue"})
    public void onMessage(Channel channel, Message message) throws Exception {
        long deliveryTag = message.getMessageProperties().getDeliveryTag();
        String messageBody = new String(message.getBody(), Charsets.UTF_8);
        InvoiceStatisticsMqPushReq invoiceStatisticsMqPushReq = (InvoiceStatisticsMqPushReq)JSON.parseObject((String)messageBody, InvoiceStatisticsMqPushReq.class);
        InvoiceEvent invoiceEvent = new InvoiceEvent();
        BeanUtils.copyProperties((Object)invoiceStatisticsMqPushReq, (Object)invoiceEvent);
        invoiceEvent.setResult(MqCustomerStatus.INIT);
        invoiceEvent.setCreateTime(LocalDateTime.now());
        invoiceEvent.setUpdateTime(LocalDateTime.now());
        invoiceEvent.setInvoiceNature(invoiceStatisticsMqPushReq.getInvoiceNature());
        if (invoiceEvent.getConfirmInvoiceTime() != null) {
            invoiceEvent.setConfirmInvoiceDate(invoiceEvent.getConfirmInvoiceTime().toLocalDate());
        } else {
            invoiceEvent.setConfirmInvoiceDate(LocalDate.now());
        }
        log.info("\u5f00\u7968\u7edf\u8ba1MQ\u6d88\u8d39\u5f00\u59cb,\u53d1\u7968\u7533\u8bf7\u5355\u53f7:{},msgid:{}", (Object)invoiceStatisticsMqPushReq.getApplyCode(), (Object)invoiceStatisticsMqPushReq.getMsgId());
        this.statisticConsumerHandler.invoiceConsumer(invoiceEvent, invoiceStatisticsMqPushReq);
        channel.basicAck(deliveryTag, false);
    }
}

