/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.handler.invoice;

import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseDayStatisticMiddle;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseMonthStatisticMiddle;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseOperateDetail;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseWeekStatisticMiddle;
import com.rocoinfo.oilcard.batch.api.enums.InvoiceOperateEnum;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseDayStatisticMiddleMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseMonthStatisticMiddleMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseWeekStatisticMiddleMapper;
import com.rocoinfo.oilcard.batch.dto.InvoiceEnterpriseDayStatisticDTO;
import com.rocoinfo.oilcard.batch.dto.InvoiceEnterpriseMonthStatisticDTO;
import com.rocoinfo.oilcard.batch.dto.InvoiceEnterpriseWeekStatisticDTO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Component
public class InvoiceEnterpriseDayStatisticMiddleHandler {
    private static final Logger log = LoggerFactory.getLogger(InvoiceEnterpriseDayStatisticMiddleHandler.class);
    @Autowired
    private InvoiceEnterpriseDayStatisticMiddleMapper dayStatisticMiddleMapper;
    @Autowired
    private InvoiceEnterpriseWeekStatisticMiddleMapper weekStatisticMiddleMapper;
    @Autowired
    private InvoiceEnterpriseMonthStatisticMiddleMapper monthStatisticMiddleMapper;

    public List<InvoiceEnterpriseDayStatisticDTO> getDayStatistic(List<? extends InvoiceEnterpriseOperateDetail> operateDetails) {
        ArrayList<InvoiceEnterpriseDayStatisticDTO> tmpStatisticDTOS = new ArrayList<InvoiceEnterpriseDayStatisticDTO>();
        for (InvoiceEnterpriseOperateDetail invoiceEnterpriseOperateDetail : operateDetails) {
            InvoiceEnterpriseDayStatisticDTO invoiceEnterpriseDayStatisticDTO = new InvoiceEnterpriseDayStatisticDTO();
            if (InvoiceOperateEnum.ARRIVE_CONFIRM == invoiceEnterpriseOperateDetail.getOperation()) {
                invoiceEnterpriseDayStatisticDTO.setDay(invoiceEnterpriseOperateDetail.getDay());
                invoiceEnterpriseDayStatisticDTO.setArrivalAmount(invoiceEnterpriseOperateDetail.getInvoiceAmount());
                invoiceEnterpriseDayStatisticDTO.setArrivalCnt(Long.valueOf(1L));
                invoiceEnterpriseDayStatisticDTO.setInvalidCnt(Long.valueOf(0L));
                invoiceEnterpriseDayStatisticDTO.setTotalCnt(Long.valueOf(0L));
            } else if (InvoiceOperateEnum.INVALID == invoiceEnterpriseOperateDetail.getOperation()) {
                invoiceEnterpriseDayStatisticDTO.setDay(invoiceEnterpriseOperateDetail.getDay());
                invoiceEnterpriseDayStatisticDTO.setInvalidCnt(Long.valueOf(1L));
                invoiceEnterpriseDayStatisticDTO.setArrivalCnt(Long.valueOf(0L));
                invoiceEnterpriseDayStatisticDTO.setTotalCnt(Long.valueOf(0L));
                invoiceEnterpriseDayStatisticDTO.setInvalidAmount(invoiceEnterpriseOperateDetail.getInvoiceAmount());
            } else if (InvoiceOperateEnum.CONFIRM == invoiceEnterpriseOperateDetail.getOperation()) {
                invoiceEnterpriseDayStatisticDTO.setDay(invoiceEnterpriseOperateDetail.getDay());
                invoiceEnterpriseDayStatisticDTO.setTotalCnt(Long.valueOf(1L));
                invoiceEnterpriseDayStatisticDTO.setInvalidCnt(Long.valueOf(0L));
                invoiceEnterpriseDayStatisticDTO.setArrivalCnt(Long.valueOf(0L));
                invoiceEnterpriseDayStatisticDTO.setTotalAmount(invoiceEnterpriseOperateDetail.getInvoiceAmount());
            }
            invoiceEnterpriseDayStatisticDTO.setEnterpriseCode(invoiceEnterpriseOperateDetail.getEnterpriseCode());
            invoiceEnterpriseDayStatisticDTO.setEnterpriseName(invoiceEnterpriseOperateDetail.getEnterpriseName());
            invoiceEnterpriseDayStatisticDTO.setBizSubjectCode(invoiceEnterpriseOperateDetail.getBizSubjectCode());
            invoiceEnterpriseDayStatisticDTO.setBizSubjectName(invoiceEnterpriseOperateDetail.getBizSubjectName());
            invoiceEnterpriseDayStatisticDTO.setInvoiceNature(invoiceEnterpriseOperateDetail.getInvoiceNature());
            invoiceEnterpriseDayStatisticDTO.setRegDate(invoiceEnterpriseOperateDetail.getRegDate());
            tmpStatisticDTOS.add(invoiceEnterpriseDayStatisticDTO);
        }
        Map<InvoiceEnterpriseDayStatisticDTO, List<InvoiceEnterpriseDayStatisticDTO>> tmpStatisticDTOListMap = tmpStatisticDTOS.stream().collect(Collectors.groupingBy(dto -> new InvoiceEnterpriseDayStatisticDTO(dto.getRegDate(), dto.getDay(), dto.getEnterpriseCode(), dto.getBizSubjectCode(), dto.getInvoiceNature())));
        ArrayList<InvoiceEnterpriseDayStatisticDTO> arrayList = new ArrayList<InvoiceEnterpriseDayStatisticDTO>();
        for (List<InvoiceEnterpriseDayStatisticDTO> value : tmpStatisticDTOListMap.values()) {
            Long normalCnt = value.stream().mapToLong(InvoiceEnterpriseDayStatisticDTO::getTotalCnt).sum();
            Long invalidCnt = value.stream().mapToLong(InvoiceEnterpriseDayStatisticDTO::getInvalidCnt).sum();
            Long arrivalCnt = value.stream().mapToLong(InvoiceEnterpriseDayStatisticDTO::getArrivalCnt).sum();
            BigDecimal normalAmount = value.stream().map(o -> {
                if (o.getTotalAmount() != null) {
                    return o.getTotalAmount();
                }
                return BigDecimal.ZERO;
            }).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal invalidAmount = value.stream().map(o -> {
                if (o.getInvalidAmount() != null) {
                    return o.getInvalidAmount();
                }
                return BigDecimal.ZERO;
            }).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal arrivalAmount = value.stream().map(o -> {
                if (o.getArrivalAmount() != null) {
                    return o.getArrivalAmount();
                }
                return BigDecimal.ZERO;
            }).reduce(BigDecimal.ZERO, BigDecimal::add);
            InvoiceEnterpriseDayStatisticDTO dto2 = value.get(0);
            InvoiceEnterpriseDayStatisticDTO statisticInvoice = new InvoiceEnterpriseDayStatisticDTO(dto2.getRegDate(), dto2.getDay(), normalCnt, invalidCnt, arrivalCnt, dto2.getEnterpriseCode(), dto2.getEnterpriseName(), dto2.getBizSubjectCode(), dto2.getBizSubjectName(), dto2.getInvoiceNature(), normalAmount, invalidAmount, arrivalAmount);
            arrayList.add(statisticInvoice);
        }
        return arrayList;
    }

    public List<InvoiceEnterpriseMonthStatisticDTO> getMonthStatistic(List<InvoiceEnterpriseDayStatisticDTO> dtos) {
        ArrayList<InvoiceEnterpriseMonthStatisticDTO> monthDtos = new ArrayList<InvoiceEnterpriseMonthStatisticDTO>();
        for (InvoiceEnterpriseDayStatisticDTO dto : dtos) {
            LocalDate day = dto.getDay();
            int year = day.getYear();
            int month = day.getMonthValue();
            InvoiceEnterpriseMonthStatisticDTO monthDto = new InvoiceEnterpriseMonthStatisticDTO(Integer.valueOf(year), Integer.valueOf(month), dto.getTotalCnt(), dto.getInvalidCnt(), dto.getArrivalCnt(), dto.getEnterpriseCode(), dto.getEnterpriseName(), dto.getBizSubjectCode(), dto.getBizSubjectName(), dto.getInvoiceNature(), dto.getTotalAmount(), dto.getInvalidAmount(), dto.getArrivalAmount(), null, null, day, this.getMonthCode(day));
            monthDtos.add(monthDto);
        }
        ArrayList<InvoiceEnterpriseMonthStatisticDTO> monthStatisticDTOList = new ArrayList<InvoiceEnterpriseMonthStatisticDTO>();
        Map<InvoiceEnterpriseMonthStatisticDTO, List<InvoiceEnterpriseMonthStatisticDTO>> invoiceEnterpriseMonthStatisticDTOListMap = monthDtos.stream().collect(Collectors.groupingBy(o -> new InvoiceEnterpriseMonthStatisticDTO(o.getYear(), o.getMonth(), o.getEnterpriseCode(), o.getBizSubjectCode(), o.getInvoiceNature())));
        for (List<InvoiceEnterpriseMonthStatisticDTO> value : invoiceEnterpriseMonthStatisticDTOListMap.values()) {
            Long normalCnt = value.stream().mapToLong(InvoiceEnterpriseMonthStatisticDTO::getTotalCnt).sum();
            Long invalidCnt = value.stream().mapToLong(InvoiceEnterpriseMonthStatisticDTO::getInvalidCnt).sum();
            Long arrivalCnt = value.stream().mapToLong(InvoiceEnterpriseMonthStatisticDTO::getArrivalCnt).sum();
            BigDecimal normalAmount = value.stream().map(o -> {
                if (o.getTotalAmount() != null) {
                    return o.getTotalAmount();
                }
                return BigDecimal.ZERO;
            }).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal invalidAmount = value.stream().map(o -> {
                if (o.getInvalidAmount() != null) {
                    return o.getInvalidAmount();
                }
                return BigDecimal.ZERO;
            }).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal arrivalAmount = value.stream().map(o -> {
                if (o.getArrivalAmount() != null) {
                    return o.getArrivalAmount();
                }
                return BigDecimal.ZERO;
            }).reduce(BigDecimal.ZERO, BigDecimal::add);
            InvoiceEnterpriseMonthStatisticDTO dto = value.get(0);
            LocalDate maxDate = value.stream().filter(o -> o.getEndDate() != null).map(InvoiceEnterpriseMonthStatisticDTO::getEndDate).distinct().max((e1, e2) -> e1.compareTo((ChronoLocalDate)e2)).get();
            LocalDate[] monthStartEndDate = this.getMonthStartEndDate(maxDate);
            InvoiceEnterpriseMonthStatisticDTO monthDto = new InvoiceEnterpriseMonthStatisticDTO(dto.getYear(), dto.getMonth(), normalCnt, invalidCnt, arrivalCnt, dto.getEnterpriseCode(), dto.getEnterpriseName(), dto.getBizSubjectCode(), dto.getBizSubjectName(), dto.getInvoiceNature(), normalAmount, invalidAmount, arrivalAmount, monthStartEndDate[0], monthStartEndDate[1], maxDate, this.getMonthCode(maxDate));
            monthStatisticDTOList.add(monthDto);
        }
        return monthStatisticDTOList;
    }

    public List<InvoiceEnterpriseWeekStatisticDTO> getWeekStatistic(List<InvoiceEnterpriseDayStatisticDTO> list) {
        ArrayList<InvoiceEnterpriseWeekStatisticDTO> dtos = new ArrayList<InvoiceEnterpriseWeekStatisticDTO>();
        for (InvoiceEnterpriseDayStatisticDTO dto : list) {
            LocalDate day = dto.getDay();
            int year = day.getYear();
            int month = day.getMonthValue();
            int week = day.get(ChronoField.ALIGNED_WEEK_OF_MONTH);
            int weekCode = this.getWeekCode(day);
            InvoiceEnterpriseWeekStatisticDTO weekStatisticDTO = new InvoiceEnterpriseWeekStatisticDTO(Integer.valueOf(year), Integer.valueOf(month), Integer.valueOf(week), Integer.valueOf(weekCode), dto.getTotalCnt(), dto.getInvalidCnt(), dto.getArrivalCnt(), dto.getEnterpriseCode(), dto.getEnterpriseName(), dto.getBizSubjectCode(), dto.getBizSubjectName(), dto.getInvoiceNature(), dto.getTotalAmount(), dto.getInvalidAmount(), dto.getArrivalAmount(), null, null, day);
            dtos.add(weekStatisticDTO);
        }
        ArrayList<InvoiceEnterpriseWeekStatisticDTO> weekStatisticDTOS = new ArrayList<InvoiceEnterpriseWeekStatisticDTO>();
        Map<InvoiceEnterpriseWeekStatisticDTO, List<InvoiceEnterpriseWeekStatisticDTO>> invoiceEnterpriseWeekStatisticDTOListMap = dtos.stream().collect(Collectors.groupingBy(o -> new InvoiceEnterpriseWeekStatisticDTO(o.getYear(), o.getMonth(), o.getWeek(), o.getEnterpriseCode(), o.getBizSubjectCode(), o.getInvoiceNature())));
        for (List<InvoiceEnterpriseWeekStatisticDTO> value : invoiceEnterpriseWeekStatisticDTOListMap.values()) {
            Long normalCnt = value.stream().mapToLong(InvoiceEnterpriseWeekStatisticDTO::getTotalCnt).sum();
            Long invalidCnt = value.stream().mapToLong(InvoiceEnterpriseWeekStatisticDTO::getInvalidCnt).sum();
            Long arrivalCnt = value.stream().mapToLong(InvoiceEnterpriseWeekStatisticDTO::getArrivalCnt).sum();
            BigDecimal normalAmount = value.stream().map(o -> {
                if (o.getTotalAmount() != null) {
                    return o.getTotalAmount();
                }
                return BigDecimal.ZERO;
            }).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal invalidAmount = value.stream().map(o -> {
                if (o.getInvalidAmount() != null) {
                    return o.getInvalidAmount();
                }
                return BigDecimal.ZERO;
            }).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal arrivalAmount = value.stream().map(o -> {
                if (o.getArrivalAmount() != null) {
                    return o.getArrivalAmount();
                }
                return BigDecimal.ZERO;
            }).reduce(BigDecimal.ZERO, BigDecimal::add);
            LocalDate maxDate = value.stream().filter(o -> o.getEndDate() != null).map(InvoiceEnterpriseWeekStatisticDTO::getEndDate).distinct().max((e1, e2) -> e1.compareTo((ChronoLocalDate)e2)).get();
            LocalDate[] startEndDate = this.getWeekStartEndDate(maxDate);
            InvoiceEnterpriseWeekStatisticDTO dto = value.get(0);
            InvoiceEnterpriseWeekStatisticDTO weekStatisticDTO = new InvoiceEnterpriseWeekStatisticDTO(dto.getYear(), dto.getMonth(), dto.getWeek(), dto.getWeekCode(), normalCnt, invalidCnt, arrivalCnt, dto.getEnterpriseCode(), dto.getEnterpriseName(), dto.getBizSubjectCode(), dto.getBizSubjectName(), dto.getInvoiceNature(), normalAmount, invalidAmount, arrivalAmount, startEndDate[0], startEndDate[1], maxDate);
            weekStatisticDTOS.add(weekStatisticDTO);
        }
        return weekStatisticDTOS;
    }

    public LocalDate[] getWeekStartEndDate(LocalDate day) {
        LocalDate monday = day.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        LocalDate sunday = day.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
        String currentMonth = day.format(DateTimeFormatter.ofPattern("yyyy-MM"));
        String sunDayMonth = sunday.format(DateTimeFormatter.ofPattern("yyyy-MM"));
        String mondayMonth = monday.format(DateTimeFormatter.ofPattern("yyyy-MM"));
        LocalDate firstDay = day.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate endDay = day.with(TemporalAdjusters.lastDayOfMonth());
        LocalDate weekStartDate = null;
        LocalDate weekEndDate = null;
        weekStartDate = !mondayMonth.equals(currentMonth) ? firstDay : monday;
        weekEndDate = !sunDayMonth.equals(currentMonth) ? endDay : sunday;
        return new LocalDate[]{weekStartDate, weekEndDate};
    }

    public LocalDate[] getMonthStartEndDate(LocalDate day) {
        LocalDate startDate = day.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate endDate = day.with(TemporalAdjusters.lastDayOfMonth());
        return new LocalDate[]{startDate, endDate};
    }

    @Transactional(rollbackFor={Exception.class})
    public void middleStatistic(List<InvoiceEnterpriseOperateDetail> operateDetails) {
        List dayStatisticDTOS = this.getDayStatistic(operateDetails);
        ArrayList<Object> invoiceEnterpriseDayStatisticMiddles = new ArrayList<Object>();
        for (InvoiceEnterpriseDayStatisticDTO dayStatisticDTO : dayStatisticDTOS) {
            InvoiceEnterpriseDayStatisticMiddle dayStatisticMiddle = new InvoiceEnterpriseDayStatisticMiddle();
            BeanUtils.copyProperties((Object)dayStatisticDTO, (Object)dayStatisticMiddle);
            dayStatisticMiddle.setStatisticDay(LocalDate.now());
            dayStatisticMiddle.setStatisticTime(LocalDateTime.now());
            LocalDate day = dayStatisticDTO.getDay();
            int weekCode = this.getWeekCode(day);
            dayStatisticMiddle.setWeekCode(Integer.valueOf(weekCode));
            dayStatisticMiddle.setYear(Integer.valueOf(day.getYear()));
            dayStatisticMiddle.setMonth(Integer.valueOf(day.getMonthValue()));
            invoiceEnterpriseDayStatisticMiddles.add(dayStatisticMiddle);
        }
        this.dayStatisticMiddleMapper.batchRealSaveOrUpdate(invoiceEnterpriseDayStatisticMiddles);
        List weekStatisticDTOS = this.getWeekStatistic(dayStatisticDTOS);
        ArrayList<InvoiceEnterpriseWeekStatisticMiddle> weekStatisticMiddles = new ArrayList<InvoiceEnterpriseWeekStatisticMiddle>();
        for (InvoiceEnterpriseWeekStatisticDTO weekStatisticDTO : weekStatisticDTOS) {
            InvoiceEnterpriseWeekStatisticMiddle weekStatisticMiddle = new InvoiceEnterpriseWeekStatisticMiddle();
            BeanUtils.copyProperties((Object)weekStatisticDTO, (Object)weekStatisticMiddle);
            weekStatisticMiddle.setStatisticDay(LocalDate.now());
            weekStatisticMiddle.setStatisticTime(LocalDateTime.now());
            weekStatisticMiddles.add(weekStatisticMiddle);
        }
        this.weekStatisticMiddleMapper.batchRealSaveOrUpdate(weekStatisticMiddles);
        List monthStatisticDTOS = this.getMonthStatistic(dayStatisticDTOS);
        ArrayList<InvoiceEnterpriseMonthStatisticMiddle> monthStatisticMiddles = new ArrayList<InvoiceEnterpriseMonthStatisticMiddle>();
        for (InvoiceEnterpriseMonthStatisticDTO monthStatisticDTO : monthStatisticDTOS) {
            InvoiceEnterpriseMonthStatisticMiddle monthStatisticMiddle = new InvoiceEnterpriseMonthStatisticMiddle();
            BeanUtils.copyProperties((Object)monthStatisticDTO, (Object)monthStatisticMiddle);
            monthStatisticMiddle.setStatisticDay(LocalDate.now());
            monthStatisticMiddle.setStatisticTime(LocalDateTime.now());
            monthStatisticMiddles.add(monthStatisticMiddle);
        }
        this.monthStatisticMiddleMapper.batchRealSaveOrUpdate(monthStatisticMiddles);
    }

    public Integer getWeekCode(LocalDate day) {
        return Integer.valueOf(day.format(DateTimeFormatter.ofPattern("yyyyMM")) + "0" + this.getWeek(day.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))));
    }

    public int getWeek(String str) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date date = sdf.parse(str);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int week = calendar.get(4);
            return week;
        }
        catch (ParseException e) {
            log.error("\u8ba1\u91cf\u5468\u8ba1\u7b97\u5f02\u5e38:{}", (Throwable)e);
            return 0;
        }
    }

    public Integer getMonthCode(LocalDate day) {
        return Integer.valueOf(day.format(DateTimeFormatter.ofPattern("yyyyMM")));
    }

    public List<InvoiceEnterpriseDayStatisticMiddle> selectEnterDayMiddleList(LocalDate startDate, LocalDate endDate) {
        Example example = new Example(InvoiceEnterpriseDayStatisticMiddle.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andBetween("day", (Object)startDate, (Object)endDate);
        return this.dayStatisticMiddleMapper.selectByExample((Object)example);
    }

    public List<InvoiceEnterpriseWeekStatisticMiddle> selectEnterWeekMiddleList(Integer startWeekCode, Integer endWeekCode) {
        Example example = new Example(InvoiceEnterpriseWeekStatisticMiddle.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andBetween("weekCode", (Object)startWeekCode, (Object)endWeekCode);
        return this.weekStatisticMiddleMapper.selectByExample((Object)example);
    }

    public List<InvoiceEnterpriseMonthStatisticMiddle> selectEnterMonthMiddleList(Integer startMonthCode, Integer endMonthCode) {
        Example example = new Example(InvoiceEnterpriseMonthStatisticMiddle.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andBetween("monthCode", (Object)startMonthCode, (Object)endMonthCode);
        return this.monthStatisticMiddleMapper.selectByExample((Object)example);
    }
}

