/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.handler.invoice;

import com.rocogz.common.api.request.CommonRequest;
import com.rocogz.common.template.BaseTransactionalTemplate;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceStatistic;
import com.rocoinfo.oilcard.batch.api.enums.InvoiceOperateEnum;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceStatisticDao;
import com.rocoinfo.oilcard.batch.dto.InvoiceStatisticsMqPushReq;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.assertj.core.util.Throwables;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class InvoiceStatisticHandler
extends BaseTransactionalTemplate<InvoiceStatisticsMqPushReq, Boolean> {
    @Resource
    private InvoiceStatisticDao invoiceStatisticDao;

    public Boolean callTransactional(CommonRequest<InvoiceStatisticsMqPushReq> commonRequest) throws Exception {
        InvoiceStatisticsMqPushReq reqData = (InvoiceStatisticsMqPushReq)commonRequest.getRequest();
        InvoiceStatistic invoiceStatistic = this.invoiceStatisticDao.getByInvoiceNature(reqData.getInvoiceNature());
        int count = 0;
        if (invoiceStatistic == null) {
            invoiceStatistic = new InvoiceStatistic();
            invoiceStatistic.setCreateTime(LocalDateTime.now());
            invoiceStatistic.setTotalAmount(BigDecimal.ZERO);
            invoiceStatistic.setTotalTaxAmount(BigDecimal.ZERO);
            invoiceStatistic.setInvalidTaxAmount(BigDecimal.ZERO);
            invoiceStatistic.setArrivalTaxAmount(BigDecimal.ZERO);
            invoiceStatistic.setTotalCnt(Integer.valueOf(0));
            invoiceStatistic.setInvalidCnt(Integer.valueOf(0));
            invoiceStatistic.setArrivalCnt(Integer.valueOf(0));
            invoiceStatistic.setInvoiceNature(reqData.getInvoiceNature());
        }
        invoiceStatistic.setUpdateTime(LocalDateTime.now());
        if (InvoiceOperateEnum.CONFIRM == reqData.getOperation()) {
            invoiceStatistic.setTotalAmount(reqData.getInvoiceAccount().add(invoiceStatistic.getTotalAmount()));
            invoiceStatistic.setTotalTaxAmount(reqData.getTaxAccount().add(invoiceStatistic.getTotalTaxAmount()));
            invoiceStatistic.setTotalCnt(Integer.valueOf(invoiceStatistic.getTotalCnt() + 1));
        } else if (InvoiceOperateEnum.INVALID == reqData.getOperation()) {
            invoiceStatistic.setInvalidCnt(Integer.valueOf(invoiceStatistic.getInvalidCnt() + 1));
            invoiceStatistic.setInvalidTaxAmount(invoiceStatistic.getInvalidTaxAmount().add(reqData.getTaxAccount()));
        } else if (InvoiceOperateEnum.ARRIVE_CONFIRM == reqData.getOperation()) {
            invoiceStatistic.setArrivalTaxAmount(invoiceStatistic.getArrivalTaxAmount().add(reqData.getTaxAccount()));
            invoiceStatistic.setArrivalCnt(Integer.valueOf(invoiceStatistic.getArrivalCnt() + 1));
        }
        count = this.invoiceStatisticDao.saveOrUpdate(invoiceStatistic);
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u7edf\u8ba1\u6570\u636e\u5931\u8d25");
        return true;
    }

    public String getErrorMsg(Throwable e) {
        String errMsg = Throwables.getStackTrace((Throwable)e);
        if (errMsg.length() > 2048) {
            errMsg = errMsg.substring(0, 2048);
        }
        return errMsg;
    }
}

