/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.oilcard.batch.job.invoice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseAccumulateStatistic;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseAccumulateStatisticMiddle;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseDayStatisticMiddle;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseDayTranstionStatisticMiddle;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseMonthStatisticMiddle;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseOperateDetail;
import com.rocoinfo.oilcard.batch.api.entity.invoice.InvoiceEnterpriseWeekStatisticMiddle;
import com.rocoinfo.oilcard.batch.api.enums.InvoiceNatureEnum;
import com.rocoinfo.oilcard.batch.api.request.common.BizSubject;
import com.rocoinfo.oilcard.batch.api.request.common.EnterpriseBasePoint;
import com.rocoinfo.oilcard.batch.api.request.invoice.InvoiceJobReq;
import com.rocoinfo.oilcard.batch.base.listener.BatchJobListener;
import com.rocoinfo.oilcard.batch.base.utils.PingYinUtil;
import com.rocoinfo.oilcard.batch.config.BatchBizSubjectConfig;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseAccumulateStatisticMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseAccumulateStatisticMiddleMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseDayStatisticMiddleMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseDayTranstionStatisticMiddleMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseMonthStatisticMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseMonthStatisticMiddleMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseWeekStatisticMapper;
import com.rocoinfo.oilcard.batch.dao.invoice.InvoiceEnterpriseWeekStatisticMiddleMapper;
import com.rocoinfo.oilcard.batch.dto.InvoiceEnterpriseDayStatisticDTO;
import com.rocoinfo.oilcard.batch.dto.InvoiceEnterpriseMonthStatisticDTO;
import com.rocoinfo.oilcard.batch.dto.InvoiceEnterpriseWeekStatisticDTO;
import com.rocoinfo.oilcard.batch.handler.batch.StepExecutionStatusHandler;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceEnterpriseDayStatisticHandler;
import com.rocoinfo.oilcard.batch.handler.invoice.InvoiceEnterpriseDayStatisticMiddleHandler;
import com.rocoinfo.oilcard.batch.job.invoice.InvoiceEnterpriseMiddleStatisticJobConfig;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import tk.mybatis.mapper.entity.Example;

@Configuration
public class InvoiceEnterpriseMiddleStatisticJobConfig {
    private static final Logger log = LoggerFactory.getLogger(InvoiceEnterpriseMiddleStatisticJobConfig.class);
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Autowired
    private StepExecutionStatusHandler stepExecutionStatusService;
    @Autowired
    private DataSource dataSource;
    @Autowired
    @Qualifier(value="invoiceEventEnterItemReader")
    private ItemReader<InvoiceEnterpriseOperateDetail> invoiceEventEnterItemReader;
    @Autowired
    @Qualifier(value="transtionDayMiddleItemWriter")
    private ItemWriter<InvoiceEnterpriseOperateDetail> transtionDayMiddleItemWriter;
    @Autowired
    @Qualifier(value="batchTaskExecutor")
    private ThreadPoolTaskExecutor batchTaskExecutor;
    @Autowired
    private InvoiceEnterpriseDayStatisticMiddleHandler dayStatisticMiddleHandler;
    @Autowired
    private InvoiceEnterpriseDayStatisticMiddleMapper dayStatisticMiddleMapper;
    @Autowired
    private InvoiceEnterpriseWeekStatisticMiddleMapper weekStatisticMiddleMapper;
    @Autowired
    private InvoiceEnterpriseMonthStatisticMiddleMapper monthStatisticMiddleMapper;
    @Autowired
    private InvoiceEnterpriseDayTranstionStatisticMiddleMapper dayTranstionStatisticMiddleMapper;
    @Autowired
    private InvoiceEnterpriseAccumulateStatisticMiddleMapper accumulateStatisticMiddleMapper;
    @Autowired
    private InvoiceEnterpriseDayStatisticHandler dayStatisticHandler;
    @Autowired
    private InvoiceEnterpriseWeekStatisticMapper weekStatisticMapper;
    @Autowired
    private InvoiceEnterpriseMonthStatisticMapper monthStatisticMapper;
    @Autowired
    private InvoiceEnterpriseAccumulateStatisticMapper accumulateStatisticMapper;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private BatchBizSubjectConfig bizSubjectConfig;

    @Bean(value={"resetInvoiceEnterMiddleJob"})
    public Job resetInvoiceEnterMiddleJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("resetInvoiceEnterMiddleJob").start(this.resetInvoiceEnterMiddleStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step resetInvoiceEnterMiddleStep() {
        return this.stepBuilderFactory.get("resetInvoiceEnterMiddleStep").tasklet((Tasklet)new /* Unavailable Anonymous Inner Class!! */).build();
    }

    private void deleteInvoiceEnterDayMiddle(LocalDate startDate, LocalDate endDate) {
        Example dayMiddleExample = new Example(InvoiceEnterpriseDayStatisticMiddle.class);
        Example.Criteria dayMiddleCriteria = dayMiddleExample.createCriteria();
        dayMiddleCriteria.andBetween("day", (Object)startDate, (Object)endDate);
        this.dayStatisticMiddleMapper.deleteByExample((Object)dayMiddleExample);
    }

    private void deleteInvoiceEnterWeekMiddle(Integer startWeekCode, Integer endWeekCode) {
        Example weekMiddleExample = new Example(InvoiceEnterpriseWeekStatisticMiddle.class);
        Example.Criteria weekMiddleCriteria = weekMiddleExample.createCriteria();
        weekMiddleCriteria.andBetween("weekCode", (Object)startWeekCode, (Object)endWeekCode);
        this.weekStatisticMiddleMapper.deleteByExample((Object)weekMiddleExample);
    }

    private void deleteInvoiceEnterMonthMiddle(Integer startMonthCode, Integer endMonthCode) {
        Example monthMiddleExample = new Example(InvoiceEnterpriseMonthStatisticMiddle.class);
        Example.Criteria monthMiddleCriteria = monthMiddleExample.createCriteria();
        monthMiddleCriteria.andBetween("monthCode", (Object)startMonthCode, (Object)endMonthCode);
        this.monthStatisticMiddleMapper.deleteByExample((Object)monthMiddleExample);
    }

    private void deleteInvoiceEnterEndDateMiddle(LocalDate regStartDate) {
        Example accumulateExample = new Example(InvoiceEnterpriseAccumulateStatisticMiddle.class);
        Example.Criteria accumulateExampleCriteria = accumulateExample.createCriteria();
        accumulateExampleCriteria.andEqualTo("endDate", (Object)regStartDate);
        this.accumulateStatisticMiddleMapper.deleteByExample((Object)accumulateExample);
    }

    @Bean(value={"invoiceEnterDayMiddleJob"})
    public Job invoiceEnterDayMiddleJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterDayMiddleJob").start(this.invoiceEnterDayMiddleStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterDayMiddleStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("invoiceEnterDayMiddleStep").tasklet((stepContribution, chunkContext) -> {
            List dayTranstionStatisticMiddles = this.dayTranstionStatisticMiddleMapper.selectDayMiddleStatistic();
            ArrayList<InvoiceEnterpriseDayStatisticMiddle> dayStatisticMiddles = new ArrayList<InvoiceEnterpriseDayStatisticMiddle>();
            for (InvoiceEnterpriseDayTranstionStatisticMiddle dayTranstionStatisticMiddle : dayTranstionStatisticMiddles) {
                InvoiceEnterpriseDayStatisticMiddle dayStatisticMiddle = new InvoiceEnterpriseDayStatisticMiddle();
                BeanUtils.copyProperties((Object)dayTranstionStatisticMiddle, (Object)dayStatisticMiddle);
                dayStatisticMiddle.setStatisticDay(LocalDate.now());
                dayStatisticMiddle.setStatisticTime(LocalDateTime.now());
                dayStatisticMiddles.add(dayStatisticMiddle);
            }
            if (dayStatisticMiddles.size() > 0) {
                this.dayStatisticMiddleMapper.batchRealSaveOrUpdate(dayStatisticMiddles);
            }
            return RepeatStatus.FINISHED;
        }).allowStartIfComplete(true)).build();
    }

    @Bean(value={"invoiceEnterWeekMiddleJob"})
    public Job invoiceEnterWeekMiddleJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterWeekMiddleJob").start(this.invoiceEnterWeekMiddleStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterWeekMiddleStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("invoiceEnterWeekMiddleStep").tasklet((stepContribution, chunkContext) -> {
            Map map = chunkContext.getStepContext().getJobParameters();
            String regDateStr = (String)map.get("regStartDate");
            LocalDate regDate = LocalDate.parse(regDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            List dayStatisticMiddles = this.dayTranstionStatisticMiddleMapper.selectByRegDate(regDate);
            ArrayList<InvoiceEnterpriseDayStatisticDTO> dtos = new ArrayList<InvoiceEnterpriseDayStatisticDTO>();
            for (InvoiceEnterpriseDayTranstionStatisticMiddle dayStatisticMiddle : dayStatisticMiddles) {
                InvoiceEnterpriseDayStatisticDTO dto = new InvoiceEnterpriseDayStatisticDTO();
                BeanUtils.copyProperties((Object)dayStatisticMiddle, (Object)dto);
                dtos.add(dto);
            }
            List weekStatisticDTOS = this.dayStatisticMiddleHandler.getWeekStatistic(dtos);
            ArrayList<InvoiceEnterpriseWeekStatisticMiddle> weekStatisticMiddles = new ArrayList<InvoiceEnterpriseWeekStatisticMiddle>();
            for (InvoiceEnterpriseWeekStatisticDTO weekStatisticDTO : weekStatisticDTOS) {
                InvoiceEnterpriseWeekStatisticMiddle weekStatisticMiddle = new InvoiceEnterpriseWeekStatisticMiddle();
                BeanUtils.copyProperties((Object)weekStatisticDTO, (Object)weekStatisticMiddle);
                weekStatisticMiddle.setStatisticDay(LocalDate.now());
                weekStatisticMiddle.setStatisticTime(LocalDateTime.now());
                weekStatisticMiddles.add(weekStatisticMiddle);
            }
            if (weekStatisticMiddles != null && weekStatisticMiddles.size() > 0) {
                this.weekStatisticMiddleMapper.batchRealSaveOrUpdate(weekStatisticMiddles);
            }
            return RepeatStatus.FINISHED;
        }).allowStartIfComplete(true)).build();
    }

    @Bean(value={"invoiceEnterAccumulateMiddleJob"})
    public Job invoiceEnterAccumulateMiddleJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterAccumulateMiddleJob").start(this.invoiceEnterAccumulateMiddleStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterAccumulateMiddleStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("invoiceEnterAccumulateMiddleStep").tasklet((stepContribution, chunkContext) -> {
            Map map = chunkContext.getStepContext().getJobParameters();
            if (map.get("regStartDate") != null && map.get("regEndDate") != null) {
                LocalDate regStartDate = LocalDate.parse(map.get("regStartDate").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                List invoiceEnterpriseDayTranstionStatisticMiddles = this.dayTranstionStatisticMiddleMapper.statisticByRegDate(regStartDate);
                ArrayList<InvoiceEnterpriseAccumulateStatisticMiddle> accumulateStatisticMiddles = new ArrayList<InvoiceEnterpriseAccumulateStatisticMiddle>();
                for (InvoiceEnterpriseDayTranstionStatisticMiddle dayTranstionStatisticMiddle : invoiceEnterpriseDayTranstionStatisticMiddles) {
                    InvoiceEnterpriseAccumulateStatisticMiddle middle = new InvoiceEnterpriseAccumulateStatisticMiddle();
                    BeanUtils.copyProperties((Object)dayTranstionStatisticMiddle, (Object)middle);
                    middle.setEnterpriseNamePinyin(PingYinUtil.getPingYin((String)dayTranstionStatisticMiddle.getEnterpriseName()));
                    middle.setEndDate(dayTranstionStatisticMiddle.getRegDate());
                    InvoiceEnterpriseAccumulateStatistic accumulateStatistic = this.accumulateStatisticMapper.selectLastEndDateData(middle.getEndDate().plusDays(-1L), middle.getEnterpriseCode(), middle.getBizSubjectCode());
                    if (accumulateStatistic != null) {
                        middle.setArrivalAmount(middle.getArrivalAmount().add(accumulateStatistic.getArrivalAmount()));
                        middle.setArrivalCnt(Long.valueOf(middle.getArrivalCnt() + accumulateStatistic.getArrivalCnt()));
                        middle.setInvalidAmount(middle.getInvalidAmount().add(accumulateStatistic.getInvalidAmount()));
                        middle.setInvalidCnt(Long.valueOf(middle.getInvalidCnt() + accumulateStatistic.getInvalidCnt()));
                        middle.setTotalAmount(middle.getTotalAmount().add(accumulateStatistic.getTotalAmount()));
                        middle.setTotalCnt(Long.valueOf(middle.getTotalCnt() + accumulateStatistic.getTotalCnt()));
                    }
                    accumulateStatisticMiddles.add(middle);
                }
                if (accumulateStatisticMiddles.size() > 0) {
                    this.accumulateStatisticMiddleMapper.batchSaveOrUpdate(accumulateStatisticMiddles);
                }
            }
            return RepeatStatus.FINISHED;
        }).allowStartIfComplete(true)).build();
    }

    @Bean(value={"invoiceEnterMonthMiddleJob"})
    public Job invoiceEnterMonthMiddleJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterMonthMiddleJob").start(this.invoiceEnterMonthMiddleStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterMonthMiddleStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("invoiceEnterMonthMiddleStep").tasklet((stepContribution, chunkContext) -> {
            Map map = chunkContext.getStepContext().getJobParameters();
            String regDateStr = (String)map.get("regStartDate");
            LocalDate regDate = LocalDate.parse(regDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            List dayStatisticMiddles = this.dayTranstionStatisticMiddleMapper.selectByRegDate(regDate);
            ArrayList<InvoiceEnterpriseDayStatisticDTO> dtos = new ArrayList<InvoiceEnterpriseDayStatisticDTO>();
            for (InvoiceEnterpriseDayTranstionStatisticMiddle dayStatisticMiddle : dayStatisticMiddles) {
                InvoiceEnterpriseDayStatisticDTO dto = new InvoiceEnterpriseDayStatisticDTO();
                BeanUtils.copyProperties((Object)dayStatisticMiddle, (Object)dto);
                dtos.add(dto);
            }
            List monthStatisticDTOList = this.dayStatisticMiddleHandler.getMonthStatistic(dtos);
            ArrayList<InvoiceEnterpriseMonthStatisticMiddle> monthStatisticMiddles = new ArrayList<InvoiceEnterpriseMonthStatisticMiddle>();
            for (InvoiceEnterpriseMonthStatisticDTO monthStatisticDTO : monthStatisticDTOList) {
                InvoiceEnterpriseMonthStatisticMiddle monthStatisticMiddle = new InvoiceEnterpriseMonthStatisticMiddle();
                BeanUtils.copyProperties((Object)monthStatisticDTO, (Object)monthStatisticMiddle);
                monthStatisticMiddle.setStatisticDay(LocalDate.now());
                monthStatisticMiddle.setStatisticTime(LocalDateTime.now());
                monthStatisticMiddles.add(monthStatisticMiddle);
            }
            if (monthStatisticMiddles != null && monthStatisticMiddles.size() > 0) {
                this.monthStatisticMiddleMapper.batchRealSaveOrUpdate(monthStatisticMiddles);
            }
            return RepeatStatus.FINISHED;
        }).allowStartIfComplete(true)).build();
    }

    @Bean(value={"invoiceEnterTranstionMiddleJob"})
    public Job invoiceEnterTranstionMiddleJob() throws Exception {
        return ((SimpleJobBuilder)this.jobBuilderFactory.get("invoiceEnterTranstionMiddleJob").start(this.invoiceEnterTranstionMiddleStep()).listener((JobExecutionListener)new BatchJobListener(this.stepExecutionStatusService))).build();
    }

    private Step invoiceEnterTranstionMiddleStep() {
        return this.stepBuilderFactory.get("invoiceEnterTranstionMiddleStep").chunk(1000).reader(this.invoiceEventEnterItemReader).writer(this.transtionDayMiddleItemWriter).taskExecutor((TaskExecutor)this.batchTaskExecutor).throttleLimit(2).build();
    }

    public void getDefault(LocalDate startDate, LocalDate endDate, String key) throws Exception {
        InvoiceJobReq invoiceJobReq = (InvoiceJobReq)this.objectMapper.readValue((String)this.redisTemplate.opsForValue().get((Object)key), InvoiceJobReq.class);
        List enterpriseBasePoints = invoiceJobReq.getBasePointList();
        List bizSubjects = invoiceJobReq.getBizSubjects();
        Long dayCnt = endDate.toEpochDay() - startDate.toEpochDay();
        Long i = 0L;
        while (i <= dayCnt) {
            ArrayList<InvoiceEnterpriseDayTranstionStatisticMiddle> dayTranstionStatisticsMiddle = new ArrayList<InvoiceEnterpriseDayTranstionStatisticMiddle>();
            LocalDate day = startDate.plusDays(i);
            for (BizSubject bizSubject : bizSubjects) {
                for (EnterpriseBasePoint enterpriseBasePoint : enterpriseBasePoints) {
                    InvoiceEnterpriseDayTranstionStatisticMiddle dayTranstionStatisticMiddle = new InvoiceEnterpriseDayTranstionStatisticMiddle();
                    dayTranstionStatisticMiddle.setStatisticDay(LocalDate.now());
                    if (bizSubject.getBizSubjectCode().equals(this.bizSubjectConfig.getGzcode())) {
                        dayTranstionStatisticMiddle.setInvoiceNature(InvoiceNatureEnum.GZROCO_BASE_POINT);
                    } else if (bizSubject.getBizSubjectCode().equals(this.bizSubjectConfig.getBjcode())) {
                        dayTranstionStatisticMiddle.setInvoiceNature(InvoiceNatureEnum.BJROCO_BASE_POINT);
                    }
                    dayTranstionStatisticMiddle.setEnterpriseCode(enterpriseBasePoint.getEnterpriseCode());
                    dayTranstionStatisticMiddle.setEnterpriseName(enterpriseBasePoint.getEnterpriseName());
                    dayTranstionStatisticMiddle.setBizSubjectCode(bizSubject.getBizSubjectCode());
                    dayTranstionStatisticMiddle.setBizSubjectName(bizSubject.getBizSubjectName());
                    dayTranstionStatisticMiddle.setMonth(Integer.valueOf(day.getMonthValue()));
                    dayTranstionStatisticMiddle.setRegDate(day);
                    dayTranstionStatisticMiddle.setStatisticTime(LocalDateTime.now());
                    dayTranstionStatisticMiddle.setWeekCode(this.dayStatisticMiddleHandler.getWeekCode(day));
                    dayTranstionStatisticMiddle.setYear(Integer.valueOf(day.getYear()));
                    dayTranstionStatisticMiddle.setArrivalAmount(BigDecimal.ZERO);
                    dayTranstionStatisticMiddle.setArrivalCnt(Long.valueOf(0L));
                    dayTranstionStatisticMiddle.setInvalidAmount(BigDecimal.ZERO);
                    dayTranstionStatisticMiddle.setInvalidCnt(Long.valueOf(0L));
                    dayTranstionStatisticMiddle.setTotalAmount(BigDecimal.ZERO);
                    dayTranstionStatisticMiddle.setTotalCnt(Long.valueOf(0L));
                    dayTranstionStatisticMiddle.setDay(day);
                    dayTranstionStatisticsMiddle.add(dayTranstionStatisticMiddle);
                }
            }
            this.dayTranstionStatisticMiddleMapper.batchSaveOrUpdate(dayTranstionStatisticsMiddle);
            Long l = i;
            Long l2 = i = Long.valueOf(i + 1L);
        }
    }

    @Bean(value={"transtionDayMiddleItemWriter"})
    @StepScope
    public ItemWriter<InvoiceEnterpriseOperateDetail> transtionDayMiddleItemWriter() {
        try {
            2 itemWriter = new /* Unavailable Anonymous Inner Class!! */;
            return itemWriter;
        }
        catch (Exception e) {
            log.error("\u53d1\u7968\u65e5\u95f4\u7edf\u8ba1\u6279\u5904\u7406\u8fc7\u6e21\u6570\u636e\u5165\u5e93\u5931\u8d25:{}", (Throwable)e);
            return null;
        }
    }

    static /* synthetic */ InvoiceEnterpriseDayStatisticMiddleHandler access$000(InvoiceEnterpriseMiddleStatisticJobConfig x0) {
        return x0.dayStatisticMiddleHandler;
    }

    static /* synthetic */ InvoiceEnterpriseDayTranstionStatisticMiddleMapper access$100(InvoiceEnterpriseMiddleStatisticJobConfig x0) {
        return x0.dayTranstionStatisticMiddleMapper;
    }

    static /* synthetic */ void access$200(InvoiceEnterpriseMiddleStatisticJobConfig x0, LocalDate x1, LocalDate x2) {
        x0.deleteInvoiceEnterDayMiddle(x1, x2);
    }

    static /* synthetic */ void access$300(InvoiceEnterpriseMiddleStatisticJobConfig x0, Integer x1, Integer x2) {
        x0.deleteInvoiceEnterWeekMiddle(x1, x2);
    }

    static /* synthetic */ void access$400(InvoiceEnterpriseMiddleStatisticJobConfig x0, Integer x1, Integer x2) {
        x0.deleteInvoiceEnterMonthMiddle(x1, x2);
    }

    static /* synthetic */ void access$500(InvoiceEnterpriseMiddleStatisticJobConfig x0, LocalDate x1) {
        x0.deleteInvoiceEnterEndDateMiddle(x1);
    }

    static /* synthetic */ InvoiceEnterpriseDayStatisticHandler access$600(InvoiceEnterpriseMiddleStatisticJobConfig x0) {
        return x0.dayStatisticHandler;
    }

    static /* synthetic */ InvoiceEnterpriseDayStatisticMiddleMapper access$700(InvoiceEnterpriseMiddleStatisticJobConfig x0) {
        return x0.dayStatisticMiddleMapper;
    }

    static /* synthetic */ InvoiceEnterpriseWeekStatisticMapper access$800(InvoiceEnterpriseMiddleStatisticJobConfig x0) {
        return x0.weekStatisticMapper;
    }

    static /* synthetic */ InvoiceEnterpriseWeekStatisticMiddleMapper access$900(InvoiceEnterpriseMiddleStatisticJobConfig x0) {
        return x0.weekStatisticMiddleMapper;
    }

    static /* synthetic */ InvoiceEnterpriseMonthStatisticMapper access$1000(InvoiceEnterpriseMiddleStatisticJobConfig x0) {
        return x0.monthStatisticMapper;
    }

    static /* synthetic */ InvoiceEnterpriseMonthStatisticMiddleMapper access$1100(InvoiceEnterpriseMiddleStatisticJobConfig x0) {
        return x0.monthStatisticMiddleMapper;
    }

    static /* synthetic */ Logger access$1200() {
        return log;
    }
}

