/*
 * Decompiled with CFR 0.152.
 */
package api;

import constant.Constants;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import listener.QuartzJobListener;
import listener.QuartzTriggerListener;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerListener;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import table.DatabaseCore;
import table.QuartzPojo;
import util.DataSourceUtil;
import util.DateUtil;

public class QuartzApi {
    private static Logger logger = LoggerFactory.getLogger(QuartzApi.class);
    private static SchedulerFactory gSchedulerFactory = new StdSchedulerFactory();

    public static void createSimpleTask(Class jobClazz, String jobName, LocalDateTime jobStartDate, LocalDateTime jobEndDate, int executeUnit, Map<String, Object> param, String description) throws Exception {
        if (jobClazz == null) {
            throw new Exception("\u3010JobClazz\u3011 Not Be Empty!");
        }
        if (StringUtils.isBlank((CharSequence)jobName)) {
            throw new Exception("\u3010JobName\u3011 Not Be Empty!!");
        }
        if (executeUnit <= 0) {
            throw new Exception("\u3010executeUnit\u3011 Not Be Empty\uff01");
        }
        String jobGroupName = jobName + "Group";
        String triggerName = jobName + "Trigger";
        String triggerGroupName = jobName + "TriggerGroup";
        if (DatabaseCore.getTaskByJobName(jobName) == null) {
            DatabaseCore.insertQuartz(jobClazz, jobName, jobGroupName, triggerName, triggerGroupName, jobStartDate, jobEndDate, executeUnit, null, description);
            QuartzApi.createSimpleJob(jobClazz, jobName, jobGroupName, triggerName, triggerGroupName, jobStartDate, jobEndDate, executeUnit, param);
        } else {
            if ("false".equals(DataSourceUtil.getQuartzColony())) {
                DatabaseCore.updateQuartz(jobClazz, jobName, jobGroupName, triggerName, triggerGroupName, jobStartDate, jobEndDate, executeUnit, null, description);
            }
            QuartzApi.createSimpleJob(jobClazz, jobName, jobGroupName, triggerName, triggerGroupName, jobStartDate, jobEndDate, executeUnit, param);
        }
    }

    public static void createCronTask(Class jobClazz, String jobName, String cron, Map<String, Object> param, String description) throws Exception {
        if (jobClazz == null) {
            throw new Exception("\u3010JobClazz\u3011 Not Be Empty!");
        }
        if (StringUtils.isBlank((CharSequence)jobName)) {
            throw new Exception("\u3010JobName\u3011 Not Be Empty!");
        }
        if (StringUtils.isBlank((CharSequence)cron)) {
            throw new Exception("\u3010cron\u3011 Not Be Empty!");
        }
        String jobGroupName = jobName + "Group";
        String triggerName = jobName + "Trigger";
        String triggerGroupName = jobName + "TriggerGroup";
        if (DatabaseCore.getTaskByJobName(jobName) == null) {
            DatabaseCore.insertQuartz(jobClazz, jobName, jobGroupName, triggerName, triggerGroupName, null, null, null, cron, description);
            QuartzApi.createCronJob(jobClazz, jobName, jobGroupName, triggerName, triggerGroupName, cron, param);
        } else {
            if ("false".equals(DataSourceUtil.getQuartzColony())) {
                DatabaseCore.updateQuartz(jobClazz, jobName, jobGroupName, triggerName, triggerGroupName, null, null, null, cron, description);
            }
            QuartzApi.createCronJob(jobClazz, jobName, jobGroupName, triggerName, triggerGroupName, cron, param);
        }
    }

    private static void createCronJob(Class jobClazz, String jobName, String jobGroupName, String triggerName, String triggerGroupName, String cron, Map<String, Object> param) {
        Scheduler scheduler = null;
        try {
            scheduler = gSchedulerFactory.getScheduler();
            JobDetail job = JobBuilder.newJob((Class)jobClazz).withIdentity(jobName, jobGroupName).build();
            if (param != null) {
                for (Map.Entry<String, Object> entry : param.entrySet()) {
                    job.getJobDataMap().put(entry.getKey(), entry.getValue());
                }
            }
            CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)cron);
            cronScheduleBuilder.withMisfireHandlingInstructionDoNothing();
            CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerName, triggerGroupName).withSchedule((ScheduleBuilder)cronScheduleBuilder).build();
            scheduler.scheduleJob(job, (Trigger)cronTrigger);
            scheduler.getListenerManager().addJobListener((JobListener)new QuartzJobListener());
            scheduler.start();
            logger.info("Cron Job\u3010" + jobName + "\u3011Create Success\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createSimpleJob(Class jobClazz, String jobName, String jobGroupName, String triggerName, String triggerGroupName, LocalDateTime jobStartDate, LocalDateTime jobEndDate, Integer executeUnit, Map<String, Object> param) {
        Scheduler scheduler = null;
        try {
            scheduler = gSchedulerFactory.getScheduler();
            JobDetail job = JobBuilder.newJob((Class)jobClazz).withIdentity(jobName, jobGroupName).build();
            if (param != null) {
                for (Map.Entry<String, Object> entry : param.entrySet()) {
                    job.getJobDataMap().put(entry.getKey(), entry.getValue());
                }
            }
            SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(triggerName, triggerGroupName).startAt(DateUtil.formatLocalDateTimeToData(jobStartDate == null ? LocalDateTime.now() : jobStartDate)).endAt(DateUtil.formatLocalDateTimeToData(jobEndDate == null ? Constants.DEFAULT_END_TIME : jobEndDate)).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(executeUnit.intValue()).repeatForever().withMisfireHandlingInstructionNextWithRemainingCount()).build();
            scheduler.scheduleJob(job, (Trigger)trigger);
            scheduler.getListenerManager().addTriggerListener((TriggerListener)new QuartzTriggerListener());
            scheduler.getListenerManager().addJobListener((JobListener)new QuartzJobListener());
            scheduler.start();
            logger.info("Simple Job\u3010" + jobName + "\u3011Create Success\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<QuartzPojo> searchTask(String keyword) {
        return DatabaseCore.searchTask(keyword);
    }

    public static void getAllJob() {
        Scheduler scheduler = null;
        try {
            scheduler = gSchedulerFactory.getScheduler();
            scheduler.getJobGroupNames();
            scheduler.getTriggerGroupNames();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void pauseJob(String jobName) {
        Scheduler scheduler = null;
        try {
            QuartzPojo quartzPojo = DatabaseCore.getTaskByJobName(jobName);
            if (quartzPojo != null && ("INIT".equals(quartzPojo.getStatus()) || "COMPLETED".equals(quartzPojo.getStatus()))) {
                scheduler = gSchedulerFactory.getScheduler();
                JobKey jobKey = JobKey.jobKey((String)jobName, (String)(jobName + "Group"));
                scheduler.pauseJob(jobKey);
                DatabaseCore.updateQuartzTaskStatus(jobName, "PAUSE");
                logger.info("Task\u3010" + jobName + "\u3011pause success\uff01");
            }
        }
        catch (Exception e) {
            logger.info("Task\u3010" + jobName + "\u3011pause fail !" + e);
            throw new RuntimeException(e);
        }
    }

    public static void resumeJob(String jobName) {
        Scheduler scheduler = null;
        try {
            QuartzPojo quartzPojo = DatabaseCore.getTaskByJobName(jobName);
            if (quartzPojo != null && "PAUSE".equals(quartzPojo.getStatus())) {
                scheduler = gSchedulerFactory.getScheduler();
                JobKey jobKey = JobKey.jobKey((String)jobName, (String)(jobName + "Group"));
                scheduler.resumeJob(jobKey);
                DatabaseCore.updateQuartzTaskStatus(jobName, "INIT");
                logger.info("Task\u3010" + jobName + "\u3011resume success \uff01");
            }
        }
        catch (Exception e) {
            logger.info("Task\u3010" + jobName + "\u3011resume fail \uff01" + e);
            throw new RuntimeException(e);
        }
    }

    public static void start(String jobName) {
        Scheduler scheduler = null;
        try {
            QuartzPojo quartzPojo = DatabaseCore.getTaskByJobName(jobName);
            scheduler = gSchedulerFactory.getScheduler();
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)(jobName + "Group"));
            scheduler.triggerJob(jobKey);
            DatabaseCore.updateQuartzTaskStatus(jobName, "EXECUTED");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void pauseAllJob() {
        Scheduler scheduler = null;
        try {
            scheduler = gSchedulerFactory.getScheduler();
            scheduler.pauseAll();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void resumeAllJob() {
        Scheduler scheduler = null;
        try {
            scheduler = gSchedulerFactory.getScheduler();
            scheduler.resumeAll();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void startAll() {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            sched.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void shutdownJobs() {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            if (!sched.isShutdown()) {
                sched.shutdown();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

