/*
 * Decompiled with CFR 0.152.
 */
package listener;

import java.time.LocalDateTime;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.Trigger;
import table.DatabaseCore;
import table.QuartzPojo;
import util.DateUtil;

public class QuartzJobListener
implements JobListener {
    public String getName() {
        return "QuartzJobListener";
    }

    public void jobToBeExecuted(JobExecutionContext jobExecutionContext) {
        Trigger trigger = jobExecutionContext.getTrigger();
        DatabaseCore.updateQuartzStartTimeAndStatus(trigger.getJobKey().getName(), DateUtil.formatLocalDateTimeToString(LocalDateTime.now()), "EXECUTED");
    }

    public void jobWasExecuted(JobExecutionContext jobExecutionContext, JobExecutionException e) {
        Trigger trigger = jobExecutionContext.getTrigger();
        QuartzPojo quartzPojo = DatabaseCore.getTaskByJobName(trigger.getJobKey().getName());
        if (quartzPojo != null && !"PAUSE".equals(quartzPojo.getStatus())) {
            DatabaseCore.updateQuartzTaskEndTimeAndStatus(trigger.getJobKey().getName(), DateUtil.formatLocalDateTimeToString(LocalDateTime.now()), "COMPLETED");
        } else {
            DatabaseCore.updateQuartzTaskEndTimeAndStatus(trigger.getJobKey().getName(), DateUtil.formatLocalDateTimeToString(LocalDateTime.now()), null);
        }
    }

    public void jobExecutionVetoed(JobExecutionContext jobExecutionContext) {
    }
}

