/*
 * Decompiled with CFR 0.152.
 */
package table;

import constant.Constants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import table.QuartzPojo;
import util.DataSourceUtil;
import util.DateUtil;

public class DatabaseCore {
    private static final String TABLE_NAME = " quartz_task ";
    private static final String COLUMN_ID = " id ";
    private static final String COLUMN_JOB_CLASS_NAME = " job_classname ";
    private static final String COLUMN_JOB_NAME = " job_name ";
    private static final String COLUMN_JOB_GROUP = " job_group ";
    private static final String COLUMN_TRIGGER_NAME = " trigger_name ";
    private static final String COLUMN_TRIGGER_GROUP = " trigger_group ";
    private static final String COLUMN_START_TIME = " start_time ";
    private static final String COLUMN_END_TIME = " end_time ";
    private static final String COLUMN_UNIT = " unit ";
    private static final String COLUMN_CRON = " cron ";
    private static final String COLUMN_STATUS = " status ";
    private static final String COLUMN_LAST_EXECUTE_START_TIME = " last_execute_start_time ";
    private static final String COLUMN_LAST_EXECUTE_END_TIME = " last_execute_end_time ";
    private static final String COLUMN_DESCRIPTION = " description ";
    private static final String INSERT_KEYWORD = " INSERT INTO ";
    private static final String UPDATE_KEYWORD = " UPDATE ";
    private static final String SELECT_KEYWORD = " SELECT ";
    private static final String FROM_KEYWORD = " FROM ";
    private static final String AS_KEYWORD = " AS ";
    private static final String VALUE_KEYWORD = " VALUES ";
    private static final String SET_KEYWORD = " SET ";
    private static final String WHERE_KEYWORD = " WHERE ";
    private static final String LIKE_KEYWORD = " LIKE ";

    private static void insert(QuartzPojo quartzPojo) {
        Connection conn = null;
        PreparedStatement pstm = null;
        try {
            conn = DataSourceUtil.getConnection();
            StringBuilder insertSql = new StringBuilder(INSERT_KEYWORD);
            insertSql.append(TABLE_NAME).append("(").append(COLUMN_JOB_CLASS_NAME).append(",").append(COLUMN_JOB_NAME).append(",").append(COLUMN_JOB_GROUP).append(",").append(COLUMN_TRIGGER_NAME).append(",").append(COLUMN_TRIGGER_GROUP).append(",").append(COLUMN_START_TIME).append(",").append(COLUMN_END_TIME).append(",").append(COLUMN_UNIT).append(",").append(COLUMN_CRON).append(",").append(COLUMN_STATUS).append(",").append(COLUMN_DESCRIPTION).append(")").append(VALUE_KEYWORD).append("(?,?,?,?,?,?,?,?,?,?,?)");
            pstm = conn.prepareStatement(insertSql.toString());
            pstm.setString(1, quartzPojo.getJobClassName());
            pstm.setString(2, quartzPojo.getJobName());
            pstm.setString(3, quartzPojo.getJobGroup());
            pstm.setString(4, quartzPojo.getTriggerName());
            pstm.setString(5, quartzPojo.getTriggerGroup());
            pstm.setString(6, quartzPojo.getStartTime());
            pstm.setString(7, quartzPojo.getEndTime());
            pstm.setInt(8, quartzPojo.getUnit());
            pstm.setString(9, quartzPojo.getCron());
            pstm.setString(10, "INIT");
            pstm.setString(11, quartzPojo.getDescription());
            pstm.execute();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DatabaseCore.closeDatabaseInfo(pstm, null, null, conn);
                throw throwable;
            }
        }
        DatabaseCore.closeDatabaseInfo(pstm, null, null, conn);
    }

    private static void update(QuartzPojo quartzPojo) {
        Connection conn = null;
        PreparedStatement pstm = null;
        try {
            conn = DataSourceUtil.getConnection();
            StringBuilder updateSql = new StringBuilder(UPDATE_KEYWORD);
            updateSql.append(TABLE_NAME).append(SET_KEYWORD).append(COLUMN_JOB_CLASS_NAME).append("=").append("?").append(",").append(COLUMN_JOB_NAME).append("=").append("?").append(",").append(COLUMN_JOB_GROUP).append("=").append("?").append(",").append(COLUMN_TRIGGER_NAME).append("=").append("?").append(",").append(COLUMN_TRIGGER_GROUP).append("=").append("?").append(",").append(COLUMN_START_TIME).append("=").append("?").append(",").append(COLUMN_END_TIME).append("=").append("?").append(",").append(COLUMN_UNIT).append("=").append("?").append(",").append(COLUMN_CRON).append("=").append("?").append(",").append(COLUMN_STATUS).append("=").append("?").append(",").append(COLUMN_DESCRIPTION).append("=").append("?").append(WHERE_KEYWORD).append(COLUMN_JOB_NAME).append("=").append("?");
            pstm = conn.prepareStatement(updateSql.toString());
            pstm.setString(1, quartzPojo.getJobClassName());
            pstm.setString(2, quartzPojo.getJobName());
            pstm.setString(3, quartzPojo.getJobGroup());
            pstm.setString(4, quartzPojo.getTriggerName());
            pstm.setString(5, quartzPojo.getTriggerGroup());
            pstm.setString(6, quartzPojo.getStartTime());
            pstm.setString(7, quartzPojo.getEndTime());
            pstm.setInt(8, quartzPojo.getUnit());
            pstm.setString(9, quartzPojo.getCron());
            pstm.setString(10, quartzPojo.getStatus());
            pstm.setString(11, quartzPojo.getDescription());
            pstm.setString(12, quartzPojo.getJobName());
            pstm.execute();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DatabaseCore.closeDatabaseInfo(pstm, null, null, conn);
                throw throwable;
            }
        }
        DatabaseCore.closeDatabaseInfo(pstm, null, null, conn);
    }

    public static void updateQuartzStartTimeAndStatus(String jobName, String lastExecuteStartTime, String status) {
        Connection conn = null;
        PreparedStatement pstm = null;
        try {
            conn = DataSourceUtil.getConnection();
            StringBuilder updateSql = new StringBuilder(UPDATE_KEYWORD);
            updateSql.append(TABLE_NAME).append(SET_KEYWORD).append(COLUMN_LAST_EXECUTE_START_TIME).append("=").append("?").append(",").append(COLUMN_STATUS).append("=").append("?").append(WHERE_KEYWORD).append(COLUMN_JOB_NAME).append("=").append("?");
            pstm = conn.prepareStatement(updateSql.toString());
            pstm.setString(1, lastExecuteStartTime);
            pstm.setString(2, status);
            pstm.setString(3, jobName);
            pstm.execute();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DatabaseCore.closeDatabaseInfo(pstm, null, null, conn);
                throw throwable;
            }
        }
        DatabaseCore.closeDatabaseInfo(pstm, null, null, conn);
    }

    public static void updateQuartzTaskEndTimeAndStatus(String jobName, String lastExecuteEndTime, String status) {
        Connection conn = null;
        PreparedStatement pstm = null;
        StringBuilder updateSql = new StringBuilder();
        boolean updateStatus = StringUtils.isNotBlank((CharSequence)status);
        try {
            updateSql.append(UPDATE_KEYWORD).append(TABLE_NAME).append(SET_KEYWORD);
            if (updateStatus) {
                updateSql.append(COLUMN_LAST_EXECUTE_END_TIME).append("=").append("?").append(",").append(COLUMN_STATUS).append("=").append("?");
            } else {
                updateSql.append(COLUMN_LAST_EXECUTE_END_TIME).append("=").append("?");
            }
            updateSql.append(WHERE_KEYWORD).append(COLUMN_JOB_NAME).append("=").append("?");
            conn = DataSourceUtil.getConnection();
            pstm = conn.prepareStatement(updateSql.toString());
            if (updateStatus) {
                pstm.setString(1, lastExecuteEndTime);
                pstm.setString(2, status);
                pstm.setString(3, jobName);
            } else {
                pstm.setString(1, lastExecuteEndTime);
                pstm.setString(2, jobName);
            }
            pstm.execute();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DatabaseCore.closeDatabaseInfo(pstm, null, null, conn);
                throw throwable;
            }
        }
        DatabaseCore.closeDatabaseInfo(pstm, null, null, conn);
    }

    public static void updateQuartzTaskStatus(String jobName, String status) {
        Connection conn = null;
        PreparedStatement pstm = null;
        try {
            conn = DataSourceUtil.getConnection();
            StringBuilder updateSql = new StringBuilder();
            updateSql.append(UPDATE_KEYWORD).append(TABLE_NAME).append(SET_KEYWORD).append(COLUMN_STATUS).append("=").append("?").append(WHERE_KEYWORD).append(COLUMN_JOB_NAME).append("=").append("?");
            pstm = conn.prepareStatement(updateSql.toString());
            pstm.setString(1, status);
            pstm.setString(2, jobName);
            pstm.execute();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DatabaseCore.closeDatabaseInfo(pstm, null, null, conn);
                throw throwable;
            }
        }
        DatabaseCore.closeDatabaseInfo(pstm, null, null, conn);
    }

    public static QuartzPojo getTaskByJobName(String jobName) {
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        QuartzPojo quartzPojo = null;
        try {
            conn = DataSourceUtil.getConnection();
            st = conn.createStatement();
            StringBuilder selectSql = new StringBuilder();
            selectSql.append(SELECT_KEYWORD).append("*").append(FROM_KEYWORD).append(TABLE_NAME).append(WHERE_KEYWORD).append(COLUMN_JOB_NAME).append("='").append(jobName).append("'");
            rs = st.executeQuery(selectSql.toString());
            while (rs.next()) {
                quartzPojo = DatabaseCore.generDomain(rs);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DatabaseCore.closeDatabaseInfo(null, rs, st, conn);
                throw throwable;
            }
        }
        DatabaseCore.closeDatabaseInfo(null, rs, st, conn);
        return quartzPojo;
    }

    public static List<QuartzPojo> searchTask(String keyword) {
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        ArrayList<QuartzPojo> quartzPojoList = new ArrayList<QuartzPojo>();
        try {
            StringBuilder selectSql = new StringBuilder();
            selectSql.append(SELECT_KEYWORD).append("*").append(FROM_KEYWORD).append(TABLE_NAME);
            if (StringUtils.isNotBlank((CharSequence)keyword)) {
                selectSql.append(WHERE_KEYWORD).append(COLUMN_JOB_NAME).append(LIKE_KEYWORD).append("'%").append(keyword).append("%'");
            }
            conn = DataSourceUtil.getConnection();
            st = conn.createStatement();
            rs = st.executeQuery(selectSql.toString());
            while (rs.next()) {
                quartzPojoList.add(DatabaseCore.generDomain(rs));
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DatabaseCore.closeDatabaseInfo(null, rs, st, conn);
                throw throwable;
            }
        }
        DatabaseCore.closeDatabaseInfo(null, rs, st, conn);
        return quartzPojoList;
    }

    public static void insertQuartz(Class jobClazz, String jobName, String jobGroupName, String triggerName, String triggerGroupName, LocalDateTime jobStartDate, LocalDateTime jobEndDate, Integer executeUnit, String cron, String description) {
        DatabaseCore.insert(DatabaseCore.generQuartzDomain(jobClazz, jobName, jobGroupName, triggerName, triggerGroupName, jobStartDate, jobEndDate, executeUnit, cron, description));
    }

    public static void updateQuartz(Class jobClazz, String jobName, String jobGroupName, String triggerName, String triggerGroupName, LocalDateTime jobStartDate, LocalDateTime jobEndDate, Integer executeUnit, String cron, String description) {
        DatabaseCore.update(DatabaseCore.generQuartzDomain(jobClazz, jobName, jobGroupName, triggerName, triggerGroupName, jobStartDate, jobEndDate, executeUnit, cron, description));
    }

    private static QuartzPojo generQuartzDomain(Class jobClazz, String jobName, String jobGroupName, String triggerName, String triggerGroupName, LocalDateTime jobStartDate, LocalDateTime jobEndDate, Integer executeUnit, String cron, String description) {
        return new QuartzPojo().setJobClassName(jobClazz.getName()).setJobName(jobName).setJobGroup(jobGroupName).setTriggerName(triggerName).setTriggerGroup(triggerGroupName).setStartTime(StringUtils.isBlank((CharSequence)cron) ? DateUtil.formatLocalDateTimeToString(jobStartDate == null ? LocalDateTime.now() : jobStartDate) : "-").setEndTime(StringUtils.isBlank((CharSequence)cron) ? DateUtil.formatLocalDateTimeToString(jobEndDate == null ? Constants.DEFAULT_END_TIME : jobEndDate) : "-").setUnit(executeUnit == null ? 0 : executeUnit).setCron(StringUtils.isNotBlank((CharSequence)cron) ? cron : "-").setStatus("INIT").setDescription(description);
    }

    private static QuartzPojo generDomain(ResultSet rs) {
        try {
            return new QuartzPojo().setId(rs.getString(COLUMN_ID.trim())).setJobClassName(rs.getString(COLUMN_JOB_CLASS_NAME.trim())).setJobName(rs.getString(COLUMN_JOB_NAME.trim())).setJobGroup(rs.getString(COLUMN_JOB_GROUP.trim())).setTriggerName(rs.getString(COLUMN_TRIGGER_NAME.trim())).setTriggerGroup(rs.getString(COLUMN_TRIGGER_GROUP.trim())).setStartTime(rs.getString(COLUMN_START_TIME.trim())).setEndTime(rs.getString(COLUMN_END_TIME.trim())).setUnit(rs.getInt(COLUMN_UNIT.trim())).setCron(rs.getString(COLUMN_CRON.trim())).setLastExecuteStartTime(rs.getString(COLUMN_LAST_EXECUTE_START_TIME.trim())).setLastExecuteEndTime(rs.getString(COLUMN_LAST_EXECUTE_END_TIME.trim())).setStatus(rs.getString(COLUMN_STATUS.trim())).setDescription(rs.getString(COLUMN_DESCRIPTION.trim()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void closeDatabaseInfo(PreparedStatement pstm, ResultSet rs, Statement st, Connection conn) {
        if (pstm != null) {
            try {
                pstm.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }
}

