/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DateUtil {
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String TIME_ZONE = "GMT+08:00";

    public static Date formatDateStrToDate(String dateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        Date date = null;
        try {
            date = StringUtils.isNotBlank((CharSequence)dateStr) ? sdf.parse(dateStr) : sdf.parse(sdf.format(new Date()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static LocalDateTime formatStringToLocalDateTime(String dateTimeStr) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS);
        LocalDateTime ldt = LocalDateTime.parse(dateTimeStr, df);
        return ldt;
    }

    public static Date formatLocalDateTimeToData(LocalDateTime dateTime) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = dateTime.atZone(zoneId);
        return Date.from(zdt.toInstant());
    }

    public static String formatLocalDateTimeToString(LocalDateTime dateTime) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS);
        return df.format(dateTime);
    }
}

