/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocoecup.account.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.rocoinfo.rocoecup.account.entity.Role;
import com.rocoinfo.rocoecup.account.entity.Team;
import com.rocoinfo.rocoecup.entity.IdEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotBlank;
import org.springside.modules.utils.Collections3;

public class User
extends IdEntity {
    private String loginName;
    private String plainPassword;
    private String password;
    private String salt;
    private String name;
    private String email;
    private String status;
    private Date registerDate;
    private Team team;
    private List<Role> roleList = Lists.newArrayList();

    @NotBlank
    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    @Transient
    @JsonIgnore
    public String getPlainPassword() {
        return this.plainPassword;
    }

    public void setPlainPassword(String plainPassword) {
        this.plainPassword = plainPassword;
    }

    @JsonIgnore
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @JsonIgnore
    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    @NotBlank
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Email
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<Role> getRoleList() {
        return this.roleList;
    }

    public void setRoleList(List<Role> roleList) {
        this.roleList = roleList;
    }

    public List<String> getRoleNameList() {
        if (this.roleList == null || this.roleList.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> roleNameList = new ArrayList<String>();
        for (Role role : this.roleList) {
            roleNameList.add(role.getName());
        }
        return roleNameList;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    @JsonIgnore
    public String getRoleNames() {
        return Collections3.extractToString(this.roleList, (String)"name", (String)", ");
    }

    public Date getRegisterDate() {
        return this.registerDate;
    }

    public void setRegisterDate(Date registerDate) {
        this.registerDate = registerDate;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this));
    }
}

