package com.rocoinfo.rocoecup.account.service;

import com.rocoinfo.rocoecup.account.entity.User;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springside.modules.utils.Clock;

/**
 * @author: Wei Liu
 * Date: 14-4-21
 * Time: AM10:30
 */
public interface AccountService {
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_INTERATIONS = 1024;

    User getUser(Long id);

    Page<User> searchUser(String loginName, String name, Pageable pageable);

    void registerUser(User user);

    void updateUser(User user);

    void deleteUser(Long id);

    User findUserByLoginName(String loginName);

    void setClock(Clock.MockClock mockClock);

    boolean isExistUser(Long id);
}
