package com.rocoinfo.rocoecup.utils;

/**
 * @author: Wei Liu
 * Date: 14-5-14
 * Time: PM2:25
 */
public class QueryString {

    /**
     * 传入queryString，返回去除pageNumber参数之后的部分。
     * 例如：
     * <ul>
     *     <li>"pageNumber=5&a=1&b=2" 结果 "a=1&b=2"</li>
     *     <li>"a=1&b=2&pageNumber=5" 结果 "a=1&b=2"</li>
     *     <li>null 结果 ""</li>
     * </ul>
     *
     * @param queryString 未解码的查询字符串
     * @return 去除pageNumber参数之后的部分
     */
    public static String removePageNumber(String queryString) {
        if (queryString != null) {
            return queryString.replaceAll("(^|&)pageNumber=(\\d*?)(&|$)", "$1").replaceAll("&$", "");
        }
        return "";
    }
}
