package com.rocoinfo.rocoecup.inventory.service;


import com.rocoinfo.rocoecup.inventory.entity.*;

import java.util.HashMap;
import java.util.List;

public interface InventoryService {

    /**
     * 入库接口
     * @param inventory
     */
    public void addInventory(Inventory inventory, Long warehouseId, HashMap<Long, Integer> shelfAndCounts);

    public InventoryPerProduct getSkuProductInventory(Long skuProductId);

    public boolean hasInventory(Long skuProductId);

    public List<Warehouse> getAllWarehouses();

    public List<Shelf> getAllShelves();

    public List<Shelf> getShelves(Long warehouseId);

    public List<CalculateInventoryEntity> calculateInventory(Long skuProductId);

    public List<CalculateWarehouseInventoryEntity> calculateWarehouseInventory(Long warehouseId);

    /**
     * 批量出库接口
     * @param inventoryPerProducts
     */
    public void reduceInventoryPerProduct(List<InventoryPerProduct> inventoryPerProducts);

    /**
     * 出库接口
     * @param inventoryPerProduct
     */
    public void reduceInventoryPerProduct(InventoryPerProduct inventoryPerProduct);

    /**
     * 锁定单件库存
     * @param inventoryPerProduct
     */
    public void lockInventoryPerProduct(InventoryPerProduct inventoryPerProduct);

    /**
     * 解锁单件库存
     * @param inventoryPerProduct
     */
    public void unlockInventoryPerProduct(InventoryPerProduct inventoryPerProduct);

    /**
     * 绑定单件库存
     * @param skuProductId  单品ID
     * @param count 数量
     * @return
     */
    public List<InventoryPerProduct> getInventoryPerProduct(Long skuProductId, int count);

}
