/*******************************************************************************
 * Copyright (c) 2005, 2014 springside.github.io
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 *******************************************************************************/
package com.rocoinfo.rocoecup.entity;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.NotBlank;

//JPA标识
public class Payment extends IdEntity {

	private String type;// 支付方式
	private Integer amount;// 支付金额
	private Integer thirdPartyPayStatus;// 如果是第三方支付，标识其状态
	private OrderItem orderItem;// 订单内容项,实际对应于某一商品

	// JSR303 BeanValidator的校验规则
	@NotBlank
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Integer getAmount() {
		return amount;
	}

	public void setAmount(Integer amount) {
		this.amount = amount;
	}

	public Integer getThirdPartyPayStatus() {
		return thirdPartyPayStatus;
	}

	public void setThirdPartyPayStatus(Integer thirdPartyPayStatus) {
		this.thirdPartyPayStatus = thirdPartyPayStatus;
	}

	// JPA 基于order_item_id列的多对一关系定义
	public OrderItem getOrderItem() {
		return orderItem;
	}

	public void setOrderItem(OrderItem orderItem) {
		this.orderItem = orderItem;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
}
