package com.rocoinfo.rocoecup.service.order;

import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;

import com.rocoinfo.rocoecup.entity.Order;
import com.rocoinfo.rocoecup.entity.OrderItem;

/**
 */
public interface OrderService {

	public Order getOrder(Long id);// 根据主键获得某一订单

	public Integer updateStatus(Order o);// 修改某订单状态

	public void saveOrder(Order o);// 下单，主要包含其内容项OrderItem

	public Page<Order> getUserOrder(Map<String, Object> searchParams, int pageNumber, int pageSize, String sortType);// 分页获得某用户订单

	// 保存各内容项的支付信息
	public Integer savePayment(List<OrderItem> items);
}
