/*******************************************************************************
 * Copyright (c) 2005, 2014 springside.github.io
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 *******************************************************************************/
package com.rocoinfo.rocoecup.entity;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.NotBlank;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocoinfo.rocoecup.account.entity.User;

public class Order extends IdEntity implements java.io.Serializable{
	/**
	 * 
	 */
	private static final long serialVersionUID = 4183117624195087768L;
	private String orderNo;// 订单号
	private User user;// 谁的订单
	private Timestamp createTime;// 订单创建时间
	private Integer deliveryTimeType;// 投递接收时间类型(节假日、工作日)
	private String note;// 客户订单备注
	private Integer status;// 订单状态
	private DeliverAddress deliverAddress;// 收货地址信息

	private List<OrderItem> items = new ArrayList<OrderItem>();

	public Order() {
	}

	public Order(Long id) {
		this.id = id;
	}

	@NotBlank
	public String getOrderNo() {
		return orderNo;
	}

	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}

	@NotBlank
	public Integer getDeliveryTimeType() {
		return deliveryTimeType;
	}

	public void setDeliveryTimeType(Integer deliveryTimeType) {
		this.deliveryTimeType = deliveryTimeType;
	}

	// @Transient
	// @JsonIgnore
	// 不持久化到数据库，也不显示在Restful接口的属性.

	// 设定JSON序列化时的日期格式
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
	public Timestamp getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Timestamp createTime) {
		this.createTime = createTime;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public DeliverAddress getDeliverAddress() {
		return deliverAddress;
	}

	public void setDeliverAddress(DeliverAddress deliverAddress) {
		this.deliverAddress = deliverAddress;
	}

	public List<OrderItem> getItems() {
		return items;
	}

	public void setItems(List<OrderItem> items) {
		this.items = items;
	}

	public void addItem(OrderItem item) {
		this.items.add(item);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

}