/*******************************************************************************
 * Copyright (c) 2005, 2014 springside.github.io
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 *******************************************************************************/
package com.rocoinfo.rocoecup.entity;

import java.sql.Timestamp;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.NotBlank;

public class Payment extends IdEntity implements java.io.Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = -8033596530702137974L;
	private Integer type;// 支付类型
	private Float amount;// 支付金额
	private Integer payStatus;// 如果是第三方支付，标识其状态
	private OrderItem orderItem;// 订单内容项,实际上对应于某一商品
	private Timestamp createTime;
	private Timestamp updateStatusTime;

	@NotBlank
	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public Float getAmount() {
		return amount;
	}

	public void setAmount(Float amount) {
		this.amount = amount;
	}

	public Integer getPayStatus() {
		return payStatus;
	}

	public void setPayStatus(Integer payStatus) {
		this.payStatus = payStatus;
	}

	// JPA 基于order_item_id列的多对一关系定义
	public OrderItem getOrderItem() {
		return orderItem;
	}

	public void setOrderItem(OrderItem orderItem) {
		this.orderItem = orderItem;
	}

	public Timestamp getCreateTime() {
		return createTime;
	}

	public Timestamp getUpdateStatusTime() {
		return updateStatusTime;
	}

	public void setUpdateStatusTime(Timestamp updateStatusTime) {
		this.updateStatusTime = updateStatusTime;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

	// 支付方式
	public static enum PayMode {

		CASH_ON_DELIVERY(1, "货到付款"), // 货到付款
		ONLINE_PAYMENT(2, "在线支付"), // 在线支付
		COME_FROM_THE_MENTION(3, "上门自提"), // 上门自提
		COMPANY_TRANSFERS(4, "公司转账"), // 公司转账
		POST_OFFICE_REMITTANCE(5, "邮局汇款")// 邮局汇款
		;

		private int code;
		private String label;

		private PayMode(final int code, final String label) {
			this.code = code;
			this.label = label;
		}

		public int getCode() {
			return code;
		}

		public String getLabel() {
			return this.label;
		}

		@Override
		public String toString() {
			return String.valueOf(this.code + "=" + this.label);
		}

	}

}
