package com.rocoinfo.rocoecup.order.service;

import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;

import com.rocoinfo.rocoecup.order.entity.DeliverAddress;
import com.rocoinfo.rocoecup.order.entity.Invoice;
import com.rocoinfo.rocoecup.order.entity.Order;
import com.rocoinfo.rocoecup.order.entity.Payment;

/**
 */
/**
 * @author wangx
 * 
 */
public interface RemoteOrderService {
	/**
	 * 根据主键获得某一订单
	 * 
	 * @param id
	 * @return
	 */
	public Order getOrder(Long id);

	/**
	 * 修改某订单状态
	 * 
	 * @param o
	 * @return
	 */
	public Integer updateStatus(Order o);

	/**
	 * 下单，主要包含其内容项OrderItem
	 * 
	 * @param o
	 * @return Order
	 */
	public Order saveOrder(Order o);

	/**
	 * 分页获得某用户订单
	 * 
	 * @param searchParams
	 * @param pageNumber
	 * @param pageSize
	 * @param sortType
	 * @return
	 */
	public Page<Order> getUserOrder(Map<String, Object> searchParams, int pageNumber, int pageSize, String sortType);

	/**
	 * 保存各内容项的支付信息
	 * 
	 * @param payments
	 */
	public void savePayment(List<Payment> payments);

	/**
	 * 
	 * 调用支付接口支付,参数是订单ID OR 钱数?
	 * 
	 * @param o
	 */

	public void payMoney(Object o);

	/**
	 * 
	 * 保存该用户的收货地址信息,注意userId不能空.
	 * orderId为null则只保存，否则更新对应订单的收货地址为该地址
	 * 
	 * @param address
	 * @param orderId
	 */

	public void saveDeliverAddress(DeliverAddress address, Long orderId);

	/**
	 * 保存该用户的发票信息,注意userId不能空.
	 * orderId为null则只保存，否则更新对应订单的发票信息为该发票信息
	 * 
	 * @param o
	 * @param orderId
	 */

	public void saveInvoice(Invoice o, Long orderId);
}
