/*******************************************************************************
 * Copyright (c) 2005, 2014 springside.github.io
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 *******************************************************************************/
package com.rocoinfo.rocoecup.order.entity;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.NotBlank;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.code.ssm.api.CacheKeyMethod;
import com.rocoinfo.rocoecup.entity.IdEntity;

public class Order extends IdEntity {
	private static final long serialVersionUID = 4183117624195087768L;

	/**
	 * 订单号
	 */
	private String orderNo;

	/**
	 * 谁的订单
	 */
	private Long userId;

	/**
	 * 订单创建时间
	 */
	private Timestamp createTime;

	/**
	 * 投递接收时间类型(节假日、工作日)
	 */
	private Integer deliveryTimeType;

	/**
	 * 客户订单备注
	 */
	private String note;

	/**
	 * 订单状态
	 */
	private Integer status;

	/**
	 * 是否优先发有货商品
	 */
	private Integer priorityExist;

	/**
	 * 发票信息
	 */
	private Long invoiceId;

	/**
	 * 收货地址信息
	 */
	private Long deliverAddressId;

	/**
	 * 是否被批改
	 */
	private Integer isUpdate;

	/**
	 * 该订单所含商品项
	 */
	private List<OrderItem> items = new ArrayList<OrderItem>();

	public Order() {
	}

	public Order(Long id) {
		this.id = id;
	}

	@NotBlank
	public String getOrderNo() {
		return orderNo;
	}

	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}

	@NotBlank
	public Integer getDeliveryTimeType() {
		return deliveryTimeType;
	}

	public void setDeliveryTimeType(Integer deliveryTimeType) {
		this.deliveryTimeType = deliveryTimeType;
	}

	// @Transient
	// @JsonIgnore
	// 不持久化到数据库，也不显示在Restful接口的属性.

	// 设定JSON序列化时的日期格式
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
	public Timestamp getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Timestamp createTime) {
		this.createTime = createTime;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Integer getPriorityExist() {
		return priorityExist;
	}

	public void setPriorityExist(Integer priorityExist) {
		this.priorityExist = priorityExist;
	}

	public Long getDeliverAddressId() {
		return deliverAddressId;
	}

	public void setDeliverAddressId(Long deliverAddressId) {
		this.deliverAddressId = deliverAddressId;
	}

	public List<OrderItem> getItems() {
		return items;
	}

	public void setItems(List<OrderItem> items) {
		this.items = items;
	}

	public void addItem(OrderItem item) {
		this.items.add(item);
	}

	public Long getInvoiceId() {
		return invoiceId;
	}

	public void setInvoiceId(Long invoiceId) {
		this.invoiceId = invoiceId;
	}

	public Integer getIsUpdate() {
		return isUpdate;
	}

	public void setIsUpdate(Integer isUpdate) {
		this.isUpdate = isUpdate;
	}

	@CacheKeyMethod
	public String getCacheKey() {
		return String.valueOf(this.id);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

}