package com.rocoinfo.rocoecup.order.entity;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.NotEmpty;

import com.rocoinfo.rocoecup.entity.IdEntity;

public class Invoice extends IdEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = -4386398905032875494L;

	/**
	 * 发票Title
	 */
	private String title;
	/**
	 * 开票方式 1:普通纸质发票 ...
	 */
	private BillingMode billingMode;

	/**
	 * 开票方式 1:明细 2:办公用品 3:电脑配件 4:耗材
	 */
	private ContentType contentType;

	/**
	 * 该开票信息的属主
	 */
	private Long userId;

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public BillingMode getBillingMode() {
		return billingMode;
	}

	public void setBillingMode(BillingMode billingMode) {
		this.billingMode = billingMode;
	}

	public ContentType getContentType() {
		return contentType;
	}

	public void setContentType(ContentType contentType) {
		this.contentType = contentType;
	}

	@NotEmpty
	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

	public static enum BillingMode {
		GENERAL_PAPER(1, "普通纸质发票"), B(2, "机打发票"), UNKNOW(-1, "未知类型");

		private int code;
		private String label;

		BillingMode(int code, String label) {
			this.code = code;
			this.label = label;
		}

		public int getCode() {
			return this.code;
		}

		public String getLabel() {
			return this.label;
		}

		public static BillingMode forCode(int code) {
			switch (code) {
			case 1:
				return GENERAL_PAPER;
			default:
				return UNKNOW;
			}
		}

		@Override
		public String toString() {
			return String.valueOf(this.code + "=" + this.label);
		}

	}

	public static enum ContentType {
		DETAILS(1, "明细"), //
		OFFICE_SUPPLIES(2, "办公用品"), //
		COMPUTER_ACCESSORIES(3, "计算机配件"), //
		CONSUMABLES(4, "耗材"), //
		UNKNOW(-1, "未知类型");

		private int code;
		private String label;

		ContentType(int code, String label) {
			this.code = code;
			this.label = label;
		}

		public int getCode() {
			return this.code;
		}

		public String getLabel() {
			return this.label;
		}

		public static ContentType forCode(int code) {
			switch (code) {
			case 1:
				return DETAILS;
			case 2:
				return OFFICE_SUPPLIES;
			case 3:
				return COMPUTER_ACCESSORIES;
			case 4:
				return CONSUMABLES;
			default:
				return UNKNOW;
			}
		}

		@Override
		public String toString() {
			return String.valueOf(this.code + "=" + this.label);
		}

	}

	public static void main(String[] args) {
	}
}
