package com.rocoinfo.rocoecup.order.service;

import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;

import com.rocoinfo.rocoecup.order.entity.Order;
import com.rocoinfo.rocoecup.order.entity.Payment;

/**
 */
/**
 * @author wangx
 * 
 */
interface RemoteOrderService {
	/**
	 * 根据主键获得某一订单
	 * 
	 * @param id
	 * @return Order
	 */
	Order getOrder(Long id);

	/**
	 * 根据主键获得某一订单的配送单视图
	 * 
	 * @param id
	 * @return
	 */
	Order getDeliveryReceipt(Long id);

	/**
	 * 分页获得某用户订单
	 * 
	 * @param searchParams
	 * @param pageNumber
	 * @param pageSize
	 * @param sortType
	 * @return
	 */
	Page<Order> getUserOrder(Map<String, Object> searchParams, int pageNumber, int pageSize, String sortType);

	/**
	 * 下单，主要包含其内容项OrderItem
	 * 
	 * @param o
	 * @return Order
	 */
	Order saveOrder(Order o);

	/**
	 * 保存各内容项的支付信息
	 * 
	 * @param payments
	 */
	void savePayment(List<Payment> payments);

	/**
	 * 修改某订单状态
	 * 
	 * @param o
	 * @return
	 */
	Integer updateStatus(Order o);

	/**
	 * 
	 * 调用支付接口支付,参数是订单ID OR 钱数?
	 * 
	 * @param o
	 */

	void payMoney(Object o);

	/**
	 * 
	 * 更新订单的收货地址,主要参数orderId,deliverAddressId
	 * 
	 * @param order
	 * @param orderId
	 */

	Integer updateDeliverAddress(Order order);

	/**
	 * 更新订单的发票信息,主要参数orderId,invoiceId
	 * 
	 * @param o
	 * @param orderId
	 */

	Integer updateInvoice(Order o);

	/**
	 * 批改订单，操作行为(将原订单移入历史，记录版本信息，插入传入订单)
	 * 
	 * @param o
	 *            准备修改的订单
	 * @param userId
	 *            操作者
	 */

	Integer updateOrder(Order o, Long userId);

	/**
	 * 订单分拆递送，操作行为(将原订单商品分组递送)
	 * 
	 * 实现：
	 * 
	 * 1、生成新的订单 2、只是修改他的配送关联信息?
	 * 
	 * @param o
	 *            要分拆的订单
	 * @param userId
	 *            操作者
	 */
	void separateOrder(Order o);

	/**
	 * 订单合并递送，操作行为(将目标订单合并于原订单递送)
	 * 
	 * @param o
	 *            原订单
	 * @param targets
	 *            合并的目的订单列表
	 */
	void mergerOrder(Order original, Order[] targets);
}
