/*******************************************************************************
 * Copyright (c) 2005, 2014 springside.github.io
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 *******************************************************************************/
package com.rocoinfo.rocoecup.order.entity;

import java.sql.Timestamp;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.NotBlank;

import com.rocoinfo.rocoecup.entity.IdEntity;

public class Payment extends IdEntity {

	private static final long serialVersionUID = -8033596530702137974L;

	/**
	 * 支付类型
	 */
	private PayMode type;//

	/**
	 * 支付金额
	 */
	private Float amount;//

	/**
	 * 如果是第三方支付，标识其状态
	 */
	private Integer payStatus;//

	/**
	 * 订单内容项,实际上对应于某一商品
	 */
	private Long orderItemId;

	/**
	 * 创建时间，也即支付时间
	 */
	private Timestamp createTime;

	/**
	 * 状态更新时间，也即支付接口返回时间
	 */
	private Timestamp updateStatusTime;

	@NotBlank
	public PayMode getType() {
		return type;
	}

	public void setType(PayMode type) {
		this.type = type;
	}

	public Float getAmount() {
		return amount;
	}

	public void setAmount(Float amount) {
		this.amount = amount;
	}

	public Integer getPayStatus() {
		return payStatus;
	}

	public void setPayStatus(Integer payStatus) {
		this.payStatus = payStatus;
	}

	public Long getOrderItemId() {
		return orderItemId;
	}

	public void setOrderItemId(Long orderItemId) {
		this.orderItemId = orderItemId;
	}

	public Timestamp getCreateTime() {
		return createTime;
	}

	public Timestamp getUpdateStatusTime() {
		return updateStatusTime;
	}

	public void setUpdateStatusTime(Timestamp updateStatusTime) {
		this.updateStatusTime = updateStatusTime;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

	// 支付方式
	public static enum PayMode {

		CASH_ON_DELIVERY(1, "货到付款"), // 货到付款
		ONLINE_PAYMENT(2, "在线支付"), // 在线支付
		COME_FROM_THE_MENTION(3, "上门自提"), // 上门自提
		COMPANY_TRANSFERS(4, "公司转账"), // 公司转账
		POST_OFFICE_REMITTANCE(5, "邮局汇款"), // 邮局汇款
		UNKNOW(-1, "未知类型")// 未知类型
		;

		private int code;
		private String label;

		private PayMode(final int code, final String label) {
			this.code = code;
			this.label = label;
		}

		public int getCode() {
			return code;
		}

		public String getLabel() {
			return this.label;
		}

		static public PayMode forCode(final int code) {
			switch (code) {
			case 1:
				return CASH_ON_DELIVERY;
			case 2:
				return ONLINE_PAYMENT;
			case 3:
				return COME_FROM_THE_MENTION;
			case 4:
				return COMPANY_TRANSFERS;
			case 5:
				return POST_OFFICE_REMITTANCE;
			default:
				return UNKNOW;
			}
		}

		@Override
		public String toString() {
			return String.valueOf(this.code + "=" + this.label);
		}

	}

}
