package com.rocoinfo.rocoecup.order.entity;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.NotEmpty;

import com.rocoinfo.rocoecup.entity.IdEntity;

public class DeliverAddress extends IdEntity {
	private static final long serialVersionUID = -5786826001274586575L;

	/**
	 * 国家
	 */
	private String county;

	/**
	 * 省份
	 */
	private String provice;

	/**
	 * 城市
	 */
	private String city;

	/**
	 * 街道
	 */
	private String street;

	/**
	 * 邮编
	 */
	private String postCode;

	/**
	 * 收货人电话
	 */
	private String phone;

	/**
	 * 收货人姓名
	 */
	private String recipients;

	/**
	 * 该地址属主
	 */
	private Long userId;

	public DeliverAddress() {
	}

	public DeliverAddress(Long id) {
		this.id = id;
	}

	public String getCounty() {
		return county;
	}

	public void setCounty(String county) {
		this.county = county;
	}

	public String getProvice() {
		return provice;
	}

	public void setProvice(String provice) {
		this.provice = provice;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getStreet() {
		return street;
	}

	public void setStreet(String street) {
		this.street = street;
	}

	public String getPostCode() {
		return postCode;
	}

	public void setPostCode(String postCode) {
		this.postCode = postCode;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getRecipients() {
		return recipients;
	}

	public void setRecipients(String recipients) {
		this.recipients = recipients;
	}

	@NotEmpty
	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
}
