/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocoecup.order.entity;

import com.rocoinfo.rocoecup.entity.IdEntity;
import java.sql.Timestamp;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.NotBlank;

public class Payment
extends IdEntity {
    private static final long serialVersionUID = -8033596530702137974L;
    private PayMode type;
    private Float amount;
    private Integer payStatus;
    private Long orderItemId;
    private Timestamp createTime;
    private Timestamp updateStatusTime;

    @NotBlank
    public PayMode getType() {
        return this.type;
    }

    public void setType(PayMode type) {
        this.type = type;
    }

    public Float getAmount() {
        return this.amount;
    }

    public void setAmount(Float amount) {
        this.amount = amount;
    }

    public Integer getPayStatus() {
        return this.payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public Long getOrderItemId() {
        return this.orderItemId;
    }

    public void setOrderItemId(Long orderItemId) {
        this.orderItemId = orderItemId;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public Timestamp getUpdateStatusTime() {
        return this.updateStatusTime;
    }

    public void setUpdateStatusTime(Timestamp updateStatusTime) {
        this.updateStatusTime = updateStatusTime;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this));
    }

    public static enum PayMode {
        CASH_ON_DELIVERY(1, "\u8d27\u5230\u4ed8\u6b3e"),
        ONLINE_PAYMENT(2, "\u5728\u7ebf\u652f\u4ed8"),
        COME_FROM_THE_MENTION(3, "\u4e0a\u95e8\u81ea\u63d0"),
        COMPANY_TRANSFERS(4, "\u516c\u53f8\u8f6c\u8d26"),
        POST_OFFICE_REMITTANCE(5, "\u90ae\u5c40\u6c47\u6b3e"),
        UNKNOW(-1, "\u672a\u77e5\u7c7b\u578b");

        private int code;
        private String label;

        private PayMode(int code, String label) {
            this.code = code;
            this.label = label;
        }

        public int getCode() {
            return this.code;
        }

        public String getLabel() {
            return this.label;
        }

        public static PayMode forCode(int code) {
            switch (code) {
                case 1: {
                    return CASH_ON_DELIVERY;
                }
                case 2: {
                    return ONLINE_PAYMENT;
                }
                case 3: {
                    return COME_FROM_THE_MENTION;
                }
                case 4: {
                    return COMPANY_TRANSFERS;
                }
                case 5: {
                    return POST_OFFICE_REMITTANCE;
                }
            }
            return UNKNOW;
        }

        public String toString() {
            return String.valueOf(this.code + "=" + this.label);
        }
    }
}

