package com.rocoinfo.rocoecup.sell.entity;

import java.sql.Timestamp;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.NotBlank;

import com.rocoinfo.rocoecup.entity.IdEntity;

public class PaymentInformation extends IdEntity {

	private static final long serialVersionUID = -8033596530702137974L;

	/**
	 * 支付类型
	 */
	private PayMode type;

	/**
	 * 支付金额
	 */
	private Float amount;

	/**
	 * 如果是第三方支付，标识其状态
	 */
	private Integer paymentStatus;

	/**
	 * 订单主键
	 */
	private Long orderId;

	/**
	 * 创建时间，也即支付时间
	 */
	private Timestamp createTime;

	/**
	 * 支付状态更新时间，也即支付接口返回时间
	 */
	private Timestamp paymentStatusUpdateTime;

	@NotBlank
	public PayMode getType() {
		return type;
	}

	public void setType(PayMode type) {
		this.type = type;
	}

	public Float getAmount() {
		return amount;
	}

	public void setAmount(Float amount) {
		this.amount = amount;
	}

	public Integer getPaymentStatus() {
		return paymentStatus;
	}

	public void setPaymentStatus(Integer paymentStatus) {
		this.paymentStatus = paymentStatus;
	}

	public Long getOrderId() {
		return orderId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Timestamp getCreateTime() {
		return createTime;
	}

	public Timestamp getPaymentStatusUpdateTime() {
		return paymentStatusUpdateTime;
	}

	public void setPaymentStatusUpdateTime(Timestamp paymentStatusUpdateTime) {
		this.paymentStatusUpdateTime = paymentStatusUpdateTime;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

	// 支付方式
	public static enum PayMode {

		ALIPAY(1, "支付宝"), // 支付宝
		INTEGRATION(2, "积分支付"), // 积分支付
		INTERNET_BANKING(3, "网银"), // 网银
		UNKNOW(-1, "未知支付方式")// 未知
		;

		private int code;
		private String label;

		private PayMode(final int code, final String label) {
			this.code = code;
			this.label = label;
		}

		public int getCode() {
			return code;
		}

		public String getLabel() {
			return this.label;
		}

		static public PayMode forCode(final int code) {
			switch (code) {
			case 1:
				return ALIPAY;
			case 2:
				return INTEGRATION;
			case 3:
				return INTERNET_BANKING;
			default:
				return UNKNOW;
			}
		}

		@Override
		public String toString() {
			return String.valueOf(this.code + "=" + this.label);
		}

	}

}
