package com.rocoinfo.rocoecup.sell.service;

import java.util.Map;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;

import com.rocoinfo.rocoecup.sell.entity.DeliveryList;

/**
 * 派送单服务接口
 * 
 * @author wangx
 * 
 */
public interface RemoteDeliveryListService {

	/**
	 * 生成派送单
	 * 
	 * @param dl
	 * @return
	 */
	Integer saveDeliveryList(DeliveryList dl);

	/**
	 * 以主键Load
	 * 
	 * @param deliveryListId
	 * @return
	 */
	DeliveryList findOne(Long deliveryListId);

	/**
	 * 以参数分页查找派送单
	 * 
	 * @param deliveryListId
	 * @return
	 */
	Page<DeliveryList> findByParamsPage(Map<String, Object> params, Integer pageNumber, Integer pageSize, Sort sort);
}
