package com.rocoinfo.rocoecup.sell.service;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.rocoinfo.rocoecup.sell.entity.DeliveryList;

/**
 * 派送单服务接口
 * 
 * @author wangx
 * 
 */
public interface DeliveryListService {

	/**
	 * 生成派送单
	 * 
	 * @param dl
	 * @return
	 */
	Integer saveDeliveryList(DeliveryList dl);

	/**
	 * 以主键Load
	 * 
	 * @param deliveryListId
	 * @return
	 */
	DeliveryList findOne(Long deliveryListId);

	/**
	 * 以参数分页查找派送单
	 * 
	 * @param deliveryListId
	 * @return
	 */
	Page<DeliveryList> findByParamPage(DeliveryListParam deliveryListParam, Pageable pageable);
}
