package com.rocoinfo.rocoecup.sell.entity;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.google.code.ssm.api.CacheKeyMethod;
import com.rocoinfo.rocoecup.entity.IdEntity;

/**
 * 派送单
 * 
 * @author wangx
 * 
 */
public class DeliveryList extends IdEntity {

	private static final long serialVersionUID = -6173020259680590800L;

	/**
	 * 派送单号
	 */
	private String deliveryNum;

	/**
	 * 快递公司ID
	 */
	private Long expressCompanyId;

	/**
	 * 运单号
	 */
	private String waybillNum;

	/**
	 * 投递地址，从用户处取得
	 */
	private Long customerAddressId;

	/**
	 * 所含明细
	 */
	private List<DeliveryListItem> items = new ArrayList<DeliveryListItem>();

	public String getDeliveryNum() {
		return deliveryNum;
	}

	public void setDeliveryNum(String deliveryNum) {
		this.deliveryNum = deliveryNum;
	}

	public Long getExpressCompanyId() {
		return expressCompanyId;
	}

	public void setExpressCompanyId(Long expressCompanyId) {
		this.expressCompanyId = expressCompanyId;
	}

	public String getWaybillNum() {
		return waybillNum;
	}

	public void setWaybillNum(String waybillNum) {
		this.waybillNum = waybillNum;
	}

	public Long getCustomerAddressId() {
		return customerAddressId;
	}

	public void setCustomerAddressId(Long customerAddressId) {
		this.customerAddressId = customerAddressId;
	}

	public List<DeliveryListItem> getItems() {
		return items;
	}

	public void setItems(List<DeliveryListItem> items) {
		this.items = items;
	}

	public void addItems(DeliveryListItem item) {
		if (items != null) {
			this.items.add(item);
		}
	}

	@CacheKeyMethod
	public String getCacheKey() {
		return String.valueOf(this.id);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
}
