/*******************************************************************************
 * Copyright (c) 2005, 2014 springside.github.io
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 *******************************************************************************/
package com.rocoinfo.rocoecup.sell.entity;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.NotBlank;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.code.ssm.api.CacheKeyMethod;
import com.rocoinfo.rocoecup.entity.IdEntity;

public class SalesOrder extends IdEntity {
	private static final long serialVersionUID = 4183117624195087768L;

	/**
	 * 订单号
	 */
	private String orderNo;

	/**
	 * 下单用户
	 */
	private Long customerId;

	/**
	 * 订单创建时间
	 */
	private Timestamp createTime;

	/**
	 * 投递接收时间类型(节假日、工作日)
	 */
	private Integer receiptTimeType;

	/**
	 * 客户订单备注
	 */
	private String note;

	/**
	 * 订单状态
	 */
	private Integer status;

	/**
	 * 发票信息
	 */
	private Long customerInvoiceId;

	/**
	 * 收货地址信息
	 */
	private Long customerAddressId;

	/**
	 * 是否被批改
	 */
	private Integer isEdited;

	/**
	 * 合作商家ID
	 */
	private Long mallId;

	/**
	 * 该订单所含商品项
	 */
	private List<SalesOrderItem> items = new ArrayList<SalesOrderItem>();

	/**
	 * 该订单所含支付信息
	 */
	private List<PaymentInformation> payments = new ArrayList<PaymentInformation>();

	/**
	 * 默认构造
	 */
	public SalesOrder() {
	}

	/**
	 * 重载构造
	 * 
	 * @param id
	 */
	public SalesOrder(Long id) {
		this.id = id;
	}

	@NotBlank
	public String getOrderNo() {
		return orderNo;
	}

	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}

	@NotBlank
	public Integer getReceiptTimeType() {
		return receiptTimeType;
	}

	public void setReceiptTimeType(Integer receiptTimeType) {
		this.receiptTimeType = receiptTimeType;
	}

	// @Transient
	// @JsonIgnore
	// 不持久化到数据库，也不显示在Restful接口的属性.

	// 设定JSON序列化时的日期格式
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
	public Timestamp getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Timestamp createTime) {
		this.createTime = createTime;
	}

	public Long getCustomerId() {
		return customerId;
	}

	public void setCustomerId(Long customerId) {
		this.customerId = customerId;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Long getCustomerAddressId() {
		return customerAddressId;
	}

	public void setCustomerAddressId(Long customerAddressId) {
		this.customerAddressId = customerAddressId;
	}

	public Long getCustomerInvoiceId() {
		return customerInvoiceId;
	}

	public void setCustomerInvoiceId(Long customerInvoiceId) {
		this.customerInvoiceId = customerInvoiceId;
	}

	public Integer getIsEdited() {
		return isEdited;
	}

	public void setIsEdited(Integer isEdited) {
		this.isEdited = isEdited;
	}

	public Long getMallId() {
		return mallId;
	}

	public void setMallId(Long mallId) {
		this.mallId = mallId;
	}

	public List<SalesOrderItem> getItems() {
		return items;
	}

	public void setItems(List<SalesOrderItem> items) {
		this.items = items;
	}

	public void addItem(SalesOrderItem item) {
		this.items.add(item);
	}

	public List<PaymentInformation> getPayments() {
		return payments;
	}

	public void setPayments(List<PaymentInformation> payments) {
		this.payments = payments;
	}

	@CacheKeyMethod
	public String getCacheKey() {
		return String.valueOf(this.id);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

}