package com.rocoinfo.rocoecup.sell.service;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class QueryParam implements Serializable {

	private static final long serialVersionUID = -6526644959963345769L;

	public Map<String, Object> toMapIgnoreNull() {
		Map<String, Object> map = new HashMap<String, Object>();
		try {
			BeanInfo beanInfo = Introspector.getBeanInfo(this.getClass());
			PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
			for (PropertyDescriptor property : propertyDescriptors) {
				String key = property.getName();

				if ("class".equals(key)) {
					continue;
				}
				Method getter = property.getReadMethod();
				Object value = getter.invoke(this);
				if (value == null) {
					continue;
				}
				map.put(key, value);

			}
		} catch (Exception e) {
			throw new RuntimeException(this.getClass() + "转换非空属性为Map时异常", e);
		}

		return map;
	}
}
