package com.rocoinfo.rocoecup.sell.service;

import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.rocoinfo.rocoecup.sell.entity.ExpressCompany;

/**
 * 快递公司接口 1、新增快递公司 2、修改快递公司属性 3、删除快递公司 4、快递公司搜索
 * 
 * @author wangx
 * 
 */
public interface ExpressCompanyService {

	/**
	 * 新增快递公司
	 * 
	 * @param ec
	 * @return
	 */
	Integer save(ExpressCompany ec);

	/**
	 * 删除一个快递公司
	 * 
	 * @param ec
	 * @return
	 */
	Integer delete(Long expressCompanyId);

	/**
	 * 修改一个快递公司
	 * 
	 * @param ec
	 * @return
	 */
	Integer update(ExpressCompany ec);

	/**
	 * 以主键获得一个快递公司
	 * 
	 * @param ec
	 * @return
	 */
	ExpressCompany findOne(Long expressCompanyId);

	/**
	 * 以参数分页查找快递公司
	 * 
	 * @param ec
	 * @return
	 */
	Page<ExpressCompany> findByParamPage(ExpressCompanyParam params, Pageable pageable);

	/**
	 * 所有快递公司
	 * 
	 * @return
	 */
	List<ExpressCompany> findAll();
}
