package com.rocoinfo.rocoecup.sell.entity;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.rocoinfo.rocoecup.entity.IdEntity;

public class SalesOrderItem extends IdEntity {
	private static final long serialVersionUID = -1151208751615066138L;

	/**
	 * 订单类型
	 */
	private Integer type;
	/**
	 * 所属订单
	 */
	private Long orderId;

	/**
	 * 单品id
	 */
	private Long skuProductId;

	/**
	 * 商品数量
	 */
	private Integer quantity;
	/**
	 * 单品下单价
	 */
	private Float price;
	/**
	 * 状态 0:未派送 1:已派送
	 */
	private Integer status;

	/**
	 * 默认构造
	 */
	public SalesOrderItem() {
	}

	/**
	 * 重载构造
	 * 
	 * @param id
	 */
	public SalesOrderItem(Long id) {
		this.id = id;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public Long getOrderId() {
		return orderId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Long getSkuProductId() {
		return skuProductId;
	}

	public void setSkuProductId(Long skuProductId) {
		this.skuProductId = skuProductId;
	}

	public Integer getQuantity() {
		return quantity;
	}

	public void setQuantity(Integer quantity) {
		this.quantity = quantity;
	}

	public Float getPrice() {
		return price;
	}

	public void setPrice(Float price) {
		this.price = price;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
}