package com.rocoinfo.rocoecup.sell.service;

import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.rocoinfo.rocoecup.sell.entity.PaymentInformation;
import com.rocoinfo.rocoecup.sell.entity.SalesOrder;

/**
 * 销售订单功能接口 1、下单 2、修改收货地址 3、修改发票信息 4、订单修改 5、订单搜索
 * 
 * @author wangx
 * 
 */
public interface SalesOrderService {
	/**
	 * 根据主键获得某一订单
	 * 
	 * @param id
	 * @return Order
	 */
	SalesOrder findOne(Long id);

	/**
	 * 分页查找订单
	 * 
	 * @param params
	 * @param pageable
	 * @return
	 */
	Page<SalesOrder> findByParamPage(SalesOrderParam params, Pageable pageable);

	/**
	 * 下单，主要包含其内容项OrderItem
	 * 
	 * @param o
	 * @return Order
	 */
	SalesOrder saveOrder(SalesOrder o);

	/**
	 * 保存各内容项的支付信息
	 * 
	 * @param payments
	 */
	Integer savePayment(List<PaymentInformation> payments);

	/**
	 * 修改某订单状态
	 * 
	 * @param o
	 * @return
	 */
	Integer updateStatus(SalesOrder o);

	/**
	 * 
	 * 更新订单的收货地址,主要参数orderId,deliverAddressId
	 * 
	 * @param order
	 * @param orderId
	 */

	Integer updateDeliverAddress(SalesOrder order);

	/**
	 * 更新订单的发票信息,主要参数orderId,invoiceId
	 * 
	 * @param o
	 * @param orderId
	 */

	Integer updateInvoice(SalesOrder o);

	/**
	 * 
	 * 调用支付接口支付,参数是订单ID OR 钱数?
	 * 
	 * @param o
	 */

	void payMoney(Object o);

	/**
	 * 批改订单，操作行为(将原订单移入历史，记录版本信息，插入传入订单)
	 * 
	 * @param o
	 *            准备修改的订单
	 * @param customerId
	 *            操作者
	 * @throws JsonProcessingException
	 */

	Integer updateOrder(SalesOrder o, Long customerId) throws JsonProcessingException;

	/**
	 * 修改Item项状态
	 * 
	 * @param orderItemId
	 *            准备修改的订单项
	 */

	Integer updateItemStatus(Long orderId,Long orderItemId, Integer status);

}
