/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.CainiaoMerchantInventoryAdjustResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CainiaoMerchantInventoryAdjustRequest
extends BaseTaobaoRequest<CainiaoMerchantInventoryAdjustResponse> {
    private String adjustRequest;
    private String appName;
    private String operation;

    public void setAdjustRequest(String adjustRequest) {
        this.adjustRequest = adjustRequest;
    }

    public void setAdjustRequest(List<MerStoreInvAdjustDto> adjustRequest) {
        this.adjustRequest = new JSONWriter(false, true).write(adjustRequest);
    }

    public String getAdjustRequest() {
        return this.adjustRequest;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getOperation() {
        return this.operation;
    }

    @Override
    public String getApiMethodName() {
        return "cainiao.merchant.inventory.adjust";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("adjust_request", this.adjustRequest);
        txtParams.put("app_name", this.appName);
        txtParams.put("operation", this.operation);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<CainiaoMerchantInventoryAdjustResponse> getResponseClass() {
        return CainiaoMerchantInventoryAdjustResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkObjectMaxListSize(this.adjustRequest, 20, "adjustRequest");
        RequestCheckUtils.checkNotEmpty(this.appName, "appName");
    }

    public static class MerStoreInvAdjustDto
    extends TaobaoObject {
        private static final long serialVersionUID = 4662717164212437281L;
        @ApiField(value="attribute")
        private String attribute;
        @ApiField(value="inventory_type")
        private Long inventoryType;
        @ApiField(value="out_biz_code")
        private String outBizCode;
        @ApiField(value="quantity")
        private Long quantity;
        @ApiField(value="sc_item_id")
        private Long scItemId;
        @ApiField(value="store_code")
        private String storeCode;

        public String getAttribute() {
            return this.attribute;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public void setAttributeString(String attribute) {
            this.attribute = attribute;
        }

        public Long getInventoryType() {
            return this.inventoryType;
        }

        public void setInventoryType(Long inventoryType) {
            this.inventoryType = inventoryType;
        }

        public String getOutBizCode() {
            return this.outBizCode;
        }

        public void setOutBizCode(String outBizCode) {
            this.outBizCode = outBizCode;
        }

        public Long getQuantity() {
            return this.quantity;
        }

        public void setQuantity(Long quantity) {
            this.quantity = quantity;
        }

        public Long getScItemId() {
            return this.scItemId;
        }

        public void setScItemId(Long scItemId) {
            this.scItemId = scItemId;
        }

        public String getStoreCode() {
            return this.storeCode;
        }

        public void setStoreCode(String storeCode) {
            this.storeCode = storeCode;
        }
    }
}

