/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.util;

import com.rocoinfo.weixin.model.MediaFile;
import com.rocoinfo.weixin.util.IOUtils;
import com.rocoinfo.weixin.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class HttpUtils {
    private static final HttpClient httpClient = new Ok3HttpClient();

    public static String get(String url) {
        return httpClient.get(url);
    }

    public static String get(String url, Map<String, String> queryParas) {
        return httpClient.get(url, queryParas);
    }

    public static String post(String url, String data) {
        return httpClient.post(url, data);
    }

    public static String upload(String url, File file, String params) {
        return httpClient.upload(url, file, params);
    }

    public static MediaFile download(String url) {
        return httpClient.download(url);
    }

    public static InputStream download(String url, String params) {
        return httpClient.download(url, params);
    }

    public static String postSSL(String url, String data, InputStream is, String password) {
        return httpClient.postSSL(url, data, is, password);
    }

    private static class Ok3HttpClient
    implements HttpClient {
        private OkHttpClient httpClient = new OkHttpClient().newBuilder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
        private static final MediaType CONTENT_TYPE_FORM = MediaType.parse((String)"application/x-www-form-urlencoded");

        public String execute(Request request) {
            try {
                Response response = this.httpClient.newCall(request).execute();
                if (!response.isSuccessful()) {
                    throw new RuntimeException("Unexpected code" + response);
                }
                return response.body().string();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String get(String url) {
            Request request = new Request.Builder().url(url).get().build();
            return this.execute(request);
        }

        @Override
        public String get(String url, Map<String, String> params) {
            HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                urlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
            }
            HttpUrl httpUrl = urlBuilder.build();
            Request request = new Request.Builder().url(httpUrl).get().build();
            return this.execute(request);
        }

        @Override
        public String post(String url, String data) {
            RequestBody body = RequestBody.create((MediaType)CONTENT_TYPE_FORM, (String)data);
            Request request = new Request.Builder().url(url).post(body).build();
            return this.execute(request);
        }

        @Override
        public String upload(String url, File file, String params) {
            RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file);
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("media", file.getName(), fileBody);
            if (StringUtils.isNotBlank(params)) {
                builder.addFormDataPart("description", params);
            }
            MultipartBody requestBody = builder.build();
            Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
            return this.execute(request);
        }

        @Override
        public MediaFile download(String url) {
            Request request = new Request.Builder().url(url).get().build();
            try {
                Response response = this.httpClient.newCall(request).execute();
                if (!response.isSuccessful()) {
                    throw new RuntimeException("Unexpected code " + response);
                }
                ResponseBody body = response.body();
                MediaType mediaType = body.contentType();
                MediaFile mediaFile = new MediaFile();
                if (mediaType.type().equals("text")) {
                    mediaFile.setError(body.string());
                } else {
                    BufferedInputStream bis = new BufferedInputStream(body.byteStream());
                    String ds = response.header("Content-disposition");
                    String fullName = ds.substring(ds.indexOf("filename=\"") + 10, ds.length() - 1);
                    String relName = fullName.substring(0, fullName.lastIndexOf("."));
                    String suffix = fullName.substring(relName.length() + 1);
                    mediaFile.setFullName(fullName);
                    mediaFile.setFileName(relName);
                    mediaFile.setSuffix(suffix);
                    mediaFile.setContentLength(body.contentLength() + "");
                    mediaFile.setContentType(body.contentType().toString());
                    mediaFile.setFileStream(bis);
                }
                return mediaFile;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public InputStream download(String url, String params) {
            Request request;
            if (StringUtils.isNotBlank(params)) {
                RequestBody body = RequestBody.create((MediaType)CONTENT_TYPE_FORM, (String)params);
                request = new Request.Builder().url(url).post(body).build();
            } else {
                request = new Request.Builder().url(url).get().build();
            }
            try {
                Response response = this.httpClient.newCall(request).execute();
                if (!response.isSuccessful()) {
                    throw new RuntimeException("Unexpected code " + response);
                }
                return response.body().byteStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String postSSL(String url, String data, InputStream is, String password) {
            RequestBody body = RequestBody.create((MediaType)CONTENT_TYPE_FORM, (String)data);
            Request request = new Request.Builder().url(url).post(body).build();
            try {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(is, password.toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(keyStore, password.toCharArray());
                KeyManager[] kms = kmf.getKeyManagers();
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(kms, null, new SecureRandom());
                OkHttpClient httpsClient = new OkHttpClient().newBuilder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).sslSocketFactory(sslContext.getSocketFactory()).build();
                Response response = httpsClient.newCall(request).execute();
                if (!response.isSuccessful()) {
                    throw new RuntimeException("Unexpected code " + response);
                }
                String string = response.body().string();
                return string;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        }
    }

    private static interface HttpClient {
        public String get(String var1);

        public String get(String var1, Map<String, String> var2);

        public String post(String var1, String var2);

        public String upload(String var1, File var2, String var3);

        public MediaFile download(String var1);

        public InputStream download(String var1, String var2);

        public String postSSL(String var1, String var2, InputStream var3, String var4);
    }
}

