/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.api;

import com.rocoinfo.weixin.api.BaseApi;
import com.rocoinfo.weixin.config.ParamManager;
import com.rocoinfo.weixin.model.ApiResult;
import com.rocoinfo.weixin.model.JssdkResult;
import com.rocoinfo.weixin.ticket.TicketManager;
import com.rocoinfo.weixin.util.HttpUtils;
import com.rocoinfo.weixin.util.JssdkUtils;
import com.rocoinfo.weixin.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class JssdkApi
extends BaseApi {
    private static final String JSAPI_TICKET = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=%s&type=jsapi";

    private JssdkApi() {
    }

    public static ApiResult getTicket() {
        String url = String.format(JSAPI_TICKET, JssdkApi.getAccessToken());
        return ApiResult.build(HttpUtils.get(url));
    }

    public static String getTicketStr() {
        ApiResult res = JssdkApi.getTicket();
        if (res.isSuccess()) {
            return String.valueOf(res.get("ticket"));
        }
        return null;
    }

    public static JssdkResult signature(String url) throws UnsupportedEncodingException {
        String signature;
        if (url.contains("#")) {
            url = url.substring(0, url.indexOf("#"));
        }
        String nonceStr = JssdkUtils.generateNonceStr(16);
        String timestamp = JssdkUtils.generateTimestamp();
        String tickect = TicketManager.getJsApiTicket();
        try {
            String encryptStr = "jsapi_ticket=" + tickect + "&noncestr=" + nonceStr + "&timestamp=" + timestamp + "&url=" + URLDecoder.decode(url, "utf-8");
            signature = JssdkUtils.encryptMessageBySHA1(encryptStr);
        }
        catch (Exception e) {
            return null;
        }
        if (StringUtils.isBlank(signature)) {
            return null;
        }
        return new JssdkResult().setAppId(ParamManager.getAppid()).setNonceStr(nonceStr).setTimestamp(timestamp).setSignature(signature);
    }
}

