/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.api;

import com.rocoinfo.weixin.api.BaseApi;
import com.rocoinfo.weixin.model.payment.req.CleanOrderQueryReq;
import com.rocoinfo.weixin.model.payment.req.CleanOrderReq;
import com.rocoinfo.weixin.model.payment.req.CloseOrderReq;
import com.rocoinfo.weixin.model.payment.req.DownloadBillReq;
import com.rocoinfo.weixin.model.payment.req.RefundQueryReq;
import com.rocoinfo.weixin.model.payment.req.RefundReq;
import com.rocoinfo.weixin.model.payment.req.UnifiedOrderReq;
import com.rocoinfo.weixin.model.payment.resp.CleanOrderQueryResp;
import com.rocoinfo.weixin.model.payment.resp.CleanOrderResp;
import com.rocoinfo.weixin.model.payment.resp.CloseOrderResp;
import com.rocoinfo.weixin.model.payment.resp.DownloadBillResp;
import com.rocoinfo.weixin.model.payment.resp.RefundResp;
import com.rocoinfo.weixin.model.payment.resp.UnifiedOrderResp;
import com.rocoinfo.weixin.util.HttpUtils;
import com.rocoinfo.weixin.util.PaymentUtils;
import com.rocoinfo.weixin.util.XmlUtils;
import java.io.InputStream;

public class PaymentApi
extends BaseApi {
    private static final String UNIFIED_ORDER_URL = "https://api.mch.weixin.qq.com/pay/unifiedorder";
    private static final String CLOSE_ORDER_URL = "https://api.mch.weixin.qq.com/pay/closeorder";
    private static final String DOWNLOAD_BILL_URL = "https://api.mch.weixin.qq.com/pay/downloadbill";
    private static final String REFUND_URL = "https://api.mch.weixin.qq.com/secapi/pay/refund";
    private static final String REFUND_QUERY_URL = "https://api.mch.weixin.qq.com/pay/refundquery";
    private static final String CLEAN_ORDER_URL = "https://api.mch.weixin.qq.com/cgi-bin/mch/customs/customdeclareorder";
    private static final String CLEAN_ORDER_QUERY_URL = "https://api.mch.weixin.qq.com/cgi-bin/mch/customs/customdeclarequery";

    private PaymentApi() {
    }

    public static String generateNonceStr(int len) {
        return PaymentUtils.generateNonceStr(len);
    }

    public static String calculateSign(Object req, String key) {
        return PaymentUtils.calculateSign(req, key);
    }

    public static UnifiedOrderResp unifiedOrder(UnifiedOrderReq req) {
        if (req == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String res = HttpUtils.post(UNIFIED_ORDER_URL, XmlUtils.toXml(req));
        return XmlUtils.fromXml(res, UnifiedOrderResp.class);
    }

    public static CloseOrderResp closeOrder(CloseOrderReq req) {
        if (req == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String res = HttpUtils.post(CLOSE_ORDER_URL, XmlUtils.toXml(req));
        return XmlUtils.fromXml(res, CloseOrderResp.class);
    }

    public static DownloadBillResp downloadBill(DownloadBillReq req) {
        if (req == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String res = HttpUtils.post(DOWNLOAD_BILL_URL, XmlUtils.toXml(req));
        if (res.indexOf("<") == 0) {
            return XmlUtils.fromXml(res, DownloadBillResp.class);
        }
        return new DownloadBillResp("SUCCESS", "", res);
    }

    public static RefundResp refund(RefundReq req, InputStream certStream) {
        if (req == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String res = HttpUtils.postSSL(REFUND_URL, XmlUtils.toXml(req), certStream, req.getMchid());
        return XmlUtils.fromXml(res, RefundResp.class);
    }

    public static String refundQuery(RefundQueryReq req) {
        if (req == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String res = HttpUtils.post(REFUND_QUERY_URL, XmlUtils.toXml(req));
        return res;
    }

    public static String refundQueryAutoSign(RefundQueryReq req, String key) {
        if (req == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String sign = PaymentApi.calculateSign(req, key);
        req.setSign(sign);
        return PaymentApi.refundQuery(req);
    }

    public static CleanOrderResp cleanOrder(CleanOrderReq req) {
        if (req == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String res = HttpUtils.post(CLEAN_ORDER_URL, XmlUtils.toXml(req));
        return XmlUtils.fromXml(res, CleanOrderResp.class);
    }

    public static CleanOrderResp cleanOrderAutoSign(CleanOrderReq req, String key) {
        if (req == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String sign = PaymentApi.calculateSign(req, key);
        req.setSign(sign);
        return PaymentApi.cleanOrder(req);
    }

    public static CleanOrderQueryResp cleanOrderQuery(CleanOrderQueryReq req) {
        if (req == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String res = HttpUtils.post(CLEAN_ORDER_QUERY_URL, XmlUtils.toXml(req));
        return XmlUtils.fromXml(res, CleanOrderQueryResp.class);
    }

    public static CleanOrderQueryResp cleanOrderQueryAutoSign(CleanOrderQueryReq req, String key) {
        if (req == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String sign = PaymentApi.calculateSign(req, key);
        req.setSign(sign);
        return PaymentApi.cleanOrderQuery(req);
    }
}

