/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.api;

import com.rocoinfo.weixin.api.BaseApi;
import com.rocoinfo.weixin.model.ApiResult;
import com.rocoinfo.weixin.util.HttpUtils;
import com.rocoinfo.weixin.util.JsonUtils;
import com.rocoinfo.weixin.util.MapUtils;
import java.util.Collection;
import java.util.Map;

public class TagApi
extends BaseApi {
    private static final String CREATE_URL = "https://api.weixin.qq.com/cgi-bin/tags/create?access_token=";
    private static final String GET_URL = "https://api.weixin.qq.com/cgi-bin/tags/get?access_token=";
    private static final String EDIT_URL = "https://api.weixin.qq.com/cgi-bin/tags/update?access_token=";
    private static final String DELETE_URL = "https://api.weixin.qq.com/cgi-bin/tags/delete?access_token=";
    private static final String GET_FANS_URL = "https://api.weixin.qq.com/cgi-bin/user/tag/get?access_token=";
    private static final String BATCH_TAG_URL = "https://api.weixin.qq.com/cgi-bin/tags/members/batchtagging?access_token=";
    private static final String BATCH_UNTAG_URL = "https://api.weixin.qq.com/cgi-bin/tags/members/batchuntagging?access_token=";
    private static final String GET_USER_TAGS_URL = "https://api.weixin.qq.com/cgi-bin/tags/getidlist?access_token=";

    private TagApi() {
    }

    public static ApiResult create(String name) {
        String url = CREATE_URL + TagApi.getAccessToken();
        Map<String, String> data = MapUtils.of("name", name);
        Map<String, Map<String, String>> params = MapUtils.of("tag", data);
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(params)));
    }

    public static ApiResult getAll() {
        String url = GET_URL + TagApi.getAccessToken();
        return ApiResult.build(HttpUtils.get(url));
    }

    public static ApiResult edit(long id, String name) {
        String url = EDIT_URL + TagApi.getAccessToken();
        Map<String, String> data = MapUtils.of("id", id, "name", name);
        Map<String, Map<String, String>> params = MapUtils.of("tag", data);
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(params)));
    }

    public static ApiResult delete(long id) {
        String url = DELETE_URL + TagApi.getAccessToken();
        Map<String, Long> data = MapUtils.of("id", id);
        Map<String, Map<String, Long>> params = MapUtils.of("tag", data);
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(params)));
    }

    public static ApiResult getFans(long id, String nextOpenid) {
        String url = GET_FANS_URL + TagApi.getAccessToken();
        Map<String, String> data = MapUtils.of("id", id, "next_openid", nextOpenid);
        Map<String, Map<String, String>> params = MapUtils.of("tag", data);
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(params)));
    }

    public static ApiResult batchTag(long id, Collection<String> collection) {
        String url = BATCH_TAG_URL + TagApi.getAccessToken();
        Map<String, Long> data = MapUtils.of("openid_list", collection, "tagid", id);
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(data)));
    }

    public static ApiResult batchUntag(long id, Collection<String> collection) {
        String url = BATCH_UNTAG_URL + TagApi.getAccessToken();
        Map<String, Long> data = MapUtils.of("openid_list", collection, "tagid", id);
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(data)));
    }

    public static ApiResult getUserTags(String openid) {
        String url = GET_USER_TAGS_URL + TagApi.getAccessToken();
        Map<String, String> params = MapUtils.of("openid", openid);
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(params)));
    }
}

